/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.common;

import java.util.Map;
import org.eclipse.riena.communication.core.hooks.CallContext;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.security.common.Activator;
import org.eclipse.riena.security.common.session.ISessionHolder;
import org.eclipse.riena.security.common.session.Session;

public class SecurityCallHook
implements ICallHook {
    private static final String SSOID = "x-compeople-ssoid";
    private ISessionHolder sessionHolder;

    public SecurityCallHook() {
        Inject.service(ISessionHolder.class).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public void bind(ISessionHolder sessionHolder) {
        this.sessionHolder = sessionHolder;
    }

    public void unbind(ISessionHolder sessionHolder) {
        if (this.sessionHolder == sessionHolder) {
            this.sessionHolder = null;
        }
    }

    public void beforeCall(CallContext callback) {
        Session session = this.sessionHolder.getSession();
        if (session != null) {
            callback.setCookie(SSOID, session.getSessionId());
        }
    }

    public void afterCall(CallContext callback) {
        Map map = callback.getSetCookies();
        if (map == null) {
            return;
        }
        String temp = (String)map.get(SSOID);
        if (temp != null) {
            this.sessionHolder.setSession(new Session(temp));
        }
    }
}

