/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.server;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.demo.common.Customer;
import org.eclipse.riena.demo.server.ICustomerRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerRepository
implements ICustomerRepository {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
    private List<Customer> customers = new ArrayList<Customer>();
    private Map<String, Customer> email2customer = new HashMap<String, Customer>();

    public CustomerRepository() {
        System.out.println("repository started");
        this.init();
    }

    @Override
    public List<Customer> search(String lastName) {
        return this.customers;
    }

    @Override
    public void store(Customer customer) {
        this.customers.add(customer);
        if (customer.getEmailAddress() != null) {
            this.email2customer.put(customer.getEmailAddress(), customer);
        }
    }

    @Override
    public Customer findCustomerWithEmailAddress(String emailAddress) {
        return this.email2customer.get(emailAddress);
    }

    private void init() {
        try {
            Customer crv = new Customer();
            crv.setLastName("Mundl");
            crv.setFirstName("Josef");
            crv.setBirthDate(DATE_FORMAT.parse("01/01/1950"));
            crv.getAddress().setStreet("Musterstr.1");
            crv.getAddress().setZipCode("12345");
            crv.getAddress().setCity("Musterstadt");
            crv.setEmailAddress("Josef.Mundl@mail.org");
            this.customers.add(crv);
            if (crv.getEmailAddress() != null) {
                this.email2customer.put(crv.getEmailAddress(), crv);
            }
            crv = new Customer();
            crv.setLastName("Muster");
            crv.setFirstName("Robert");
            crv.setBirthDate(DATE_FORMAT.parse("01/04/1955"));
            crv.getAddress().setStreet("Willibaldgasse");
            crv.getAddress().setZipCode("12366");
            crv.getAddress().setCity("Musterhaus");
            crv.setEmailAddress("Robert.Muster@mail.org");
            this.customers.add(crv);
            if (crv.getEmailAddress() != null) {
                this.email2customer.put(crv.getEmailAddress(), crv);
            }
            crv = new Customer();
            crv.setLastName("Muster-Maier");
            crv.setFirstName("Trulli");
            crv.setBirthDate(DATE_FORMAT.parse("21/06/1964"));
            crv.getAddress().setStreet("Willibaldgasse");
            crv.getAddress().setZipCode("12345");
            crv.getAddress().setCity("Musterstadt");
            crv.setEmailAddress("Trulli.Muster-Maier@mail.org");
            this.customers.add(crv);
            if (crv.getEmailAddress() != null) {
                this.email2customer.put(crv.getEmailAddress(), crv);
            }
            crv = new Customer();
            crv.setLastName("Mustermann");
            crv.setFirstName("Elfriede");
            crv.setBirthDate(DATE_FORMAT.parse("01/04/1955"));
            crv.getAddress().setStreet("Musterstr.1");
            crv.getAddress().setZipCode("12345");
            crv.getAddress().setCity("Musterstadt");
            crv.setEmailAddress("Elfriede.Mustermann@mail.org");
            this.customers.add(crv);
            if (crv.getEmailAddress() != null) {
                this.email2customer.put(crv.getEmailAddress(), crv);
            }
            crv = new Customer();
            crv.setLastName("Mustermann");
            crv.setFirstName("Ingo");
            crv.setBirthDate(DATE_FORMAT.parse("01/01/1950"));
            crv.getAddress().setStreet("Musterstr.1");
            crv.getAddress().setZipCode("12345");
            crv.getAddress().setCity("Musterstadt");
            crv.setEmailAddress("Ingo.Mustermann@mail.org");
            this.customers.add(crv);
            if (crv.getEmailAddress() != null) {
                this.email2customer.put(crv.getEmailAddress(), crv);
            }
        }
        catch (ParseException p) {
            System.out.println(p.getMessage());
        }
    }
}

