/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.common.TypecastingObject;
import org.eclipse.riena.navigation.listener.INavigationNodeListenerable;
import org.eclipse.riena.navigation.ui.controllers.NavigationUIFilterApplier;
import org.eclipse.riena.ui.core.context.IContext;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.controller.IController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NavigationNodeController<N extends INavigationNode<?>>
extends TypecastingObject
implements INavigationNodeController,
IController,
IContext {
    private N navigationNode;
    private Map<String, IRidget> ridgets = new HashMap<String, IRidget>();
    private NavigationUIFilterApplier<N> nodeListener;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();

    public NavigationNodeController() {
        this(null);
    }

    public NavigationNodeController(N navigationNode) {
        this.nodeListener = new NavigationUIFilterApplier();
        if (navigationNode != null) {
            this.setNavigationNode(navigationNode);
        }
    }

    public N getNavigationNode() {
        return this.navigationNode;
    }

    public void setNavigationNode(N navigationNode) {
        if (this.getNavigationNode() instanceof INavigationNodeListenerable) {
            ((INavigationNodeListenerable)this.getNavigationNode()).removeListener(this.nodeListener);
        }
        this.navigationNode = navigationNode;
        navigationNode.setNavigationNodeController((INavigationNodeController)this);
        if (this.getNavigationNode() instanceof INavigationNodeListenerable) {
            ((INavigationNodeListenerable)this.getNavigationNode()).addListener(this.nodeListener);
        }
    }

    public boolean allowsActivate(INavigationNode<?> pNode, INavigationContext context) {
        return true;
    }

    public boolean allowsDeactivate(INavigationNode<?> pNode, INavigationContext context) {
        return true;
    }

    public void afterBind() {
        this.updateNavigationNodeMarkers();
    }

    public boolean isActivated() {
        return this.getNavigationNode() != null && this.getNavigationNode().isActivated();
    }

    public boolean isEnabled() {
        return this.getNavigationNode() != null && this.getNavigationNode().isEnabled();
    }

    public boolean isVisible() {
        return this.getNavigationNode() != null && this.getNavigationNode().isVisible();
    }

    public boolean isDeactivated() {
        return this.getNavigationNode() == null || this.getNavigationNode().isDeactivated();
    }

    public boolean isCreated() {
        return this.getNavigationNode() == null || this.getNavigationNode().isCreated();
    }

    public boolean allowsDispose(INavigationNode<?> node, INavigationContext context) {
        return true;
    }

    public void addRidget(String id, IRidget ridget) {
        ridget.addPropertyChangeListener("marker", this.propertyChangeListener);
        ridget.addPropertyChangeListener("showing", this.propertyChangeListener);
        this.ridgets.put(id, ridget);
    }

    public IRidget getRidget(String id) {
        IRidget result = this.ridgets.get(id);
        if (result == null && id.indexOf(46) != -1) {
            String parentId = id.substring(0, id.lastIndexOf(46));
            String childId = id.substring(id.lastIndexOf(46) + 1);
            IRidget parent = this.ridgets.get(parentId);
            if (parent instanceof IRidgetContainer) {
                result = ((IRidgetContainer)parent).getRidget(childId);
            }
        }
        return result;
    }

    public Collection<? extends IRidget> getRidgets() {
        return this.ridgets.values();
    }

    private void addRidgetMarkers(IRidget ridget, List<IMarker> combinedMarkers) {
        if (ridget instanceof IBasicMarkableRidget && ((IBasicMarkableRidget)ridget).isVisible() && ((IBasicMarkableRidget)ridget).isEnabled()) {
            this.addRidgetMarkers((IBasicMarkableRidget)ridget, combinedMarkers);
        } else if (ridget instanceof IRidgetContainer) {
            this.addRidgetMarkers((IRidgetContainer)ridget, combinedMarkers);
        }
    }

    private void addRidgetMarkers(IBasicMarkableRidget ridget, List<IMarker> combinedMarkers) {
        combinedMarkers.addAll(ridget.getMarkers());
    }

    private void addRidgetMarkers(IRidgetContainer ridgetContainer, List<IMarker> combinedMarkers) {
        for (IRidget ridget : ridgetContainer.getRidgets()) {
            this.addRidgetMarkers(ridget, combinedMarkers);
        }
    }

    protected void updateNavigationNodeMarkers() {
        Collection errorMarkers = this.getNavigationNode().getMarkersOfType(ErrorMarker.class);
        for (IMarker marker : errorMarkers) {
            this.getNavigationNode().removeMarker(marker);
        }
        Collection mandatroyMarkers = this.getNavigationNode().getMarkersOfType(MandatoryMarker.class);
        for (IMarker marker : mandatroyMarkers) {
            this.getNavigationNode().removeMarker(marker);
        }
        for (IMarker marker : this.getRidgetMarkers()) {
            MandatoryMarker mandatoryMarker;
            if (marker instanceof ErrorMarker) {
                this.getNavigationNode().addMarker(marker);
                continue;
            }
            if (!(marker instanceof MandatoryMarker) || (mandatoryMarker = (MandatoryMarker)marker).isDisabled()) continue;
            this.getNavigationNode().addMarker(marker);
        }
    }

    private List<IMarker> getRidgetMarkers() {
        ArrayList<IMarker> combinedMarkers = new ArrayList<IMarker>();
        this.addRidgetMarkers((IRidgetContainer)this, combinedMarkers);
        return combinedMarkers;
    }

    protected void updateIcon(IWindowRidget windowRidget) {
        if (windowRidget == null) {
            return;
        }
        String nodeIcon = this.getNavigationNode().getIcon();
        windowRidget.setIcon(nodeIcon);
    }

    public void setBlocked(boolean blocked) {
        if (this.getNavigationNode() != null) {
            this.getNavigationNode().setBlocked(blocked);
        }
    }

    public boolean isBlocked() {
        return this.getNavigationNode() != null && this.getNavigationNode().isBlocked();
    }

    public NavigationNodeController<?> getParentController() {
        if (this.getNavigationNode() != null && this.getNavigationNode().getParent() == null) {
            return null;
        }
        return (NavigationNodeController)this.navigationNode.getParent().getNavigationNodeController();
    }

    public void setContext(String key, Object value) {
        Assert.isNotNull(this.getNavigationNode(), (String)"NavigationNode may not be null");
        this.getNavigationNode().setContext(key, value);
    }

    public Object getContext(String key) {
        Assert.isNotNull(this.getNavigationNode(), (String)"NavigationNode may not be null");
        return this.getNavigationNode().getContext(key);
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            NavigationNodeController.this.updateNavigationNodeMarkers();
        }
    }
}

