/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.model.SimpleNavigationNodeAdapter;
import org.eclipse.riena.ui.ridgets.IContextUpdateListener;
import org.eclipse.riena.ui.ridgets.IVisualContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeEventDelegation
extends SimpleNavigationNodeAdapter
implements IVisualContextManager {
    private List<IContextUpdateListener> listeners = new ArrayList<IContextUpdateListener>();
    private Map<Object, List<IContextUpdateListener>> context2Observers = new HashMap<Object, List<IContextUpdateListener>>();

    public void activated(INavigationNode source) {
        this.contextUpdated(source);
    }

    public void beforeDeactivated(INavigationNode source) {
        for (IContextUpdateListener listener : this.listeners) {
            listener.beforeContextUpdate((Object)source);
        }
    }

    public void deactivated(INavigationNode source) {
        this.contextUpdated(source);
    }

    private void contextUpdated(INavigationNode source) {
        ArrayList<IContextUpdateListener> toDelete = new ArrayList<IContextUpdateListener>();
        for (IContextUpdateListener listener : this.listeners) {
            if (!listener.contextUpdated((Object)source)) continue;
            toDelete.add(listener);
        }
        this.listeners.removeAll(toDelete);
    }

    public List<Object> getActiveContexts(List<Object> contexts) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (Object object : contexts) {
            INavigationNode node;
            if (!(object instanceof INavigationNode) || !(node = (INavigationNode)object).isActivated()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public void addContextUpdateListener(IContextUpdateListener listener, Object context) {
        if (context instanceof INavigationNode) {
            INavigationNode node = (INavigationNode)context;
            node.addSimpleListener((ISimpleNavigationNodeListener)this);
            this.registerObserver(context, listener);
            this.listeners.add(listener);
        }
    }

    private void registerObserver(Object context, IContextUpdateListener listener) {
        List<IContextUpdateListener> observers = this.context2Observers.get(context);
        if (observers == null) {
            observers = new LinkedList<IContextUpdateListener>();
            this.context2Observers.put(context, observers);
        }
        observers.add(listener);
    }

    public void removeContextUpdateListener(IContextUpdateListener listener, Object context) {
        List<IContextUpdateListener> observers = this.context2Observers.get(context);
        if (observers == null) {
            return;
        }
        this.listeners.remove(listener);
        if (observers.size() == 1) {
            this.context2Observers.remove(context);
            INavigationNode node = null;
            if (context instanceof INavigationNode) {
                node = (INavigationNode)INavigationNode.class.cast(context);
                node.removeSimpleListener((ISimpleNavigationNodeListener)this);
            }
            return;
        }
        observers.remove(listener);
    }
}

