/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.repository.ICompositeRepository;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.osgi.util.NLS;

public class CompositeRepositoryApplication
extends AbstractApplication {
    private List childrenToAdd = new ArrayList();
    private List childrenToRemove = new ArrayList();
    private boolean failOnExists = false;
    private String comparatorID = null;

    public IStatus run(IProgressMonitor monitor) throws ProvisionException {
        try {
            RepositoryDescriptor child;
            this.initializeRepos((IProgressMonitor)new NullProgressMonitor());
            ICompositeRepository metadataRepo = (ICompositeRepository)this.destinationMetadataRepository;
            CompositeArtifactRepository artifactRepo = (CompositeArtifactRepository)this.destinationArtifactRepository;
            Iterator iterator = this.childrenToRemove.iterator();
            while (iterator.hasNext()) {
                child = (RepositoryDescriptor)iterator.next();
                if (child.isArtifact() && artifactRepo != null) {
                    artifactRepo.removeChild(child.getOriginalRepoLocation());
                }
                if (!child.isMetadata() || metadataRepo == null) continue;
                metadataRepo.removeChild(child.getOriginalRepoLocation());
            }
            iterator = this.childrenToAdd.iterator();
            while (iterator.hasNext()) {
                child = (RepositoryDescriptor)iterator.next();
                if (child.isArtifact() && artifactRepo != null) {
                    artifactRepo.addChild(child.getOriginalRepoLocation());
                }
                if (!child.isMetadata() || metadataRepo == null) continue;
                metadataRepo.addChild(child.getOriginalRepoLocation());
            }
            if (this.comparatorID != null && !artifactRepo.validate(this.comparatorID)) {
                Status status = new Status(4, "org.eclipse.equinox.p2.transformer", NLS.bind((String)Messages.CompositeRepositoryApplication_failedComparator, (Object)this.comparatorID));
                return status;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.finalizeRepositories();
        }
    }

    public void addChild(RepositoryDescriptor child) {
        this.childrenToAdd.add(child);
    }

    public void removeChild(RepositoryDescriptor child) {
        this.childrenToRemove.add(child);
    }

    public void setFailOnExists(boolean value) {
        this.failOnExists = value;
    }

    protected IArtifactRepository initializeDestination(RepositoryDescriptor toInit, IArtifactRepositoryManager mgr) throws ProvisionException {
        mgr.removeRepository(toInit.getRepoLocation());
        try {
            IArtifactRepository repository = mgr.loadRepository(toInit.getRepoLocation(), null);
            if (this.validRepositoryLocation((IRepository)repository) && this.initDestinationRepository((IRepository)repository, toInit)) {
                return repository;
            }
            throw new ProvisionException((IStatus)new Status(1, "org.eclipse.equinox.p2.transformer", NLS.bind((String)Messages.CompositeRepository_composite_repository_exists, (Object)toInit.getRepoLocation())));
        }
        catch (ProvisionException e) {
            if (e.getStatus().getCode() != 1000) {
                if (e.getCause() instanceof MalformedURLException) {
                    throw new ProvisionException(NLS.bind((String)Messages.exception_invalidDestination, (Object)toInit.getRepoLocation()), e.getCause());
                }
                throw e;
            }
            IArtifactRepository source = null;
            try {
                if (toInit.getFormat() != null) {
                    source = mgr.loadRepository(toInit.getFormat(), 0, null);
                }
            }
            catch (ProvisionException provisionException) {}
            try {
                IArtifactRepository repo = mgr.createRepository(toInit.getRepoLocation(), toInit.getName() != null ? toInit.getName() : (source != null ? source.getName() : Messages.CompositeRepository_default_artifactRepo_name), "org.eclipse.equinox.p2.artifact.repository.compositeRepository", source != null ? source.getProperties() : null);
                this.initRepository((IRepository)repo, toInit);
                return repo;
            }
            catch (IllegalStateException e2) {
                mgr.removeRepository(toInit.getRepoLocation());
                throw e2;
            }
        }
    }

    protected IMetadataRepository initializeDestination(RepositoryDescriptor toInit, IMetadataRepositoryManager mgr) throws ProvisionException {
        mgr.removeRepository(toInit.getRepoLocation());
        try {
            IMetadataRepository repository = mgr.loadRepository(toInit.getRepoLocation(), null);
            if (!this.validRepositoryLocation((IRepository)repository) && this.initDestinationRepository((IRepository)repository, toInit)) {
                throw new ProvisionException((IStatus)new Status(1, "org.eclipse.equinox.p2.transformer", NLS.bind((String)Messages.CompositeRepository_composite_repository_exists, (Object)toInit.getRepoLocation())));
            }
            return repository;
        }
        catch (ProvisionException e) {
            if (e.getStatus().getCode() != 1000) {
                if (e.getCause() instanceof MalformedURLException) {
                    throw new ProvisionException(NLS.bind((String)Messages.exception_invalidDestination, (Object)toInit.getRepoLocation()), e.getCause());
                }
                throw e;
            }
            IMetadataRepository source = null;
            try {
                if (toInit.getFormat() != null) {
                    source = mgr.loadRepository(toInit.getFormat(), 0, null);
                }
            }
            catch (ProvisionException provisionException) {}
            try {
                IMetadataRepository repo = mgr.createRepository(toInit.getRepoLocation(), toInit.getName() != null ? toInit.getName() : (source != null ? source.getName() : Messages.CompositeRepository_default_metadataRepo_name), "org.eclipse.equinox.p2.metadata.repository.compositeRepository", source != null ? source.getProperties() : null);
                this.initRepository((IRepository)repo, toInit);
                return repo;
            }
            catch (IllegalStateException e2) {
                mgr.removeRepository(toInit.getRepoLocation());
                throw e2;
            }
        }
    }

    private boolean validRepositoryLocation(IRepository repository) throws ProvisionException {
        if (repository instanceof ICompositeRepository) {
            if (this.failOnExists) {
                throw new ProvisionException(NLS.bind((String)Messages.CompositeRepository_composite_repository_exists, (Object)repository.getLocation()));
            }
            RepositoryHelper.validDestinationRepository((IRepository)repository);
            return true;
        }
        return true;
    }

    private void initRepository(IRepository repository, RepositoryDescriptor desc) {
        RepositoryHelper.validDestinationRepository((IRepository)repository);
        if (desc.isCompressed() && !repository.getProperties().containsKey("p2.compressed")) {
            repository.setProperty("p2.compressed", String.valueOf(true));
        }
    }

    public void setComparator(String value) {
        this.comparatorID = value;
    }
}

