/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.internal.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IBrowserRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractValueRidget;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;

public class BrowserRidget
extends AbstractValueRidget
implements IBrowserRidget {
    private final BrowserUrlListener locationListener = new BrowserUrlListener();
    private String url;

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, Browser.class);
    }

    protected void bindUIControl() {
        Browser control = this.getUIControl();
        if (control != null) {
            this.updateURL();
            control.addLocationListener((LocationListener)this.locationListener);
        }
    }

    protected void unbindUIControl() {
        Browser control = this.getUIControl();
        if (control != null) {
            control.removeLocationListener((LocationListener)this.locationListener);
        }
        super.unbindUIControl();
    }

    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)"url");
    }

    public Browser getUIControl() {
        return (Browser)super.getUIControl();
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public void setUrl(String url) {
        String oldValue = this.getUrl();
        this.url = url;
        this.updateURL();
        this.firePropertyChange("url", oldValue, this.url);
    }

    private void updateURL() {
        Browser control = this.getUIControl();
        if (control != null) {
            String theUrl;
            String string = theUrl = this.getUrl() != null ? this.getUrl() : "";
            if (!control.getUrl().equals(theUrl)) {
                this.locationListener.setBlock(false);
                try {
                    control.setUrl(theUrl);
                }
                finally {
                    this.locationListener.setBlock(true);
                }
            }
        }
    }

    private final class BrowserUrlListener
    implements LocationListener {
        private boolean canBlock = true;

        private BrowserUrlListener() {
        }

        public void setBlock(boolean canBlock) {
            this.canBlock = canBlock;
        }

        public void changing(LocationEvent event) {
            if (BrowserRidget.this.isOutputOnly() && this.canBlock) {
                event.doit = false;
            }
        }

        public void changed(LocationEvent event) {
            if (event.top) {
                BrowserRidget.this.setUrl(event.location);
            }
        }
    }
}

