/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSWTRidget
extends AbstractSWTWidgetRidget {
    private FocusManager focusManager = new FocusManager();
    private boolean focusable = true;

    public static void assertType(Object uiControl, Class<?> type) {
        if (uiControl != null && !type.isAssignableFrom(uiControl.getClass())) {
            String expectedClassName = type.getSimpleName();
            String controlClassName = uiControl.getClass().getSimpleName();
            throw new BindingException("uiControl of  must be a " + expectedClassName + " but was a " + controlClassName);
        }
    }

    public Control getUIControl() {
        return (Control)super.getUIControl();
    }

    @Override
    public final void requestFocus() {
        if (this.isFocusable() && this.getUIControl() != null) {
            Control control = this.getUIControl();
            control.setFocus();
        }
    }

    @Override
    public final boolean hasFocus() {
        if (this.getUIControl() != null) {
            Control control = this.getUIControl();
            return control.isFocusControl();
        }
        return false;
    }

    @Override
    public final boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public final void setFocusable(boolean focusable) {
        if (this.focusable != focusable) {
            this.focusable = focusable;
        }
    }

    public boolean isVisible() {
        if (!this.getMarkersOfType(HiddenMarker.class).isEmpty()) {
            return false;
        }
        if (this.getUIControl() != null) {
            return this.getUIControl().isVisible();
        }
        return this.savedVisibleState;
    }

    @Override
    protected void unbindUIControl() {
        this.savedVisibleState = this.isVisible();
    }

    @Override
    protected final void installListeners() {
        super.installListeners();
        if (this.getUIControl() != null) {
            this.getUIControl().addFocusListener((FocusListener)this.focusManager);
            this.getUIControl().addMouseListener((MouseListener)this.focusManager);
        }
    }

    @Override
    protected final void uninstallListeners() {
        if (this.getUIControl() != null) {
            this.getUIControl().removeFocusListener((FocusListener)this.focusManager);
            this.getUIControl().removeMouseListener((MouseListener)this.focusManager);
        }
        super.uninstallListeners();
    }

    @Override
    protected final void updateEnabled() {
        if (this.getUIControl() != null) {
            this.getUIControl().setEnabled(this.isEnabled());
        }
    }

    @Override
    protected final void updateToolTip() {
        if (this.getUIControl() != null) {
            this.getUIControl().setToolTipText(this.getToolTipText());
        }
    }

    private final class FocusManager
    extends MouseAdapter
    implements FocusListener {
        private boolean clickToFocus;

        private FocusManager() {
        }

        public void focusGained(FocusEvent e) {
            if (this.isFocusable()) {
                AbstractSWTRidget.this.fireFocusGained(new org.eclipse.riena.ui.ridgets.listener.FocusEvent(null, (IRidget)AbstractSWTRidget.this));
            } else {
                Control control = (Control)e.widget;
                Composite parent = control.getParent();
                Control target = this.findFocusTarget(control, parent.getTabList());
                if (target != null) {
                    target.setFocus();
                } else {
                    Composite pParent = parent.getParent();
                    if (pParent != null && (target = this.findFocusTarget((Control)parent, pParent.getTabList())) != null) {
                        target.setFocus();
                    }
                }
            }
        }

        public void focusLost(FocusEvent e) {
            if (this.isFocusable()) {
                this.clickToFocus = false;
                AbstractSWTRidget.this.fireFocusLost(new org.eclipse.riena.ui.ridgets.listener.FocusEvent((IRidget)AbstractSWTRidget.this, null));
            }
        }

        public void mouseDown(MouseEvent e) {
            if (AbstractSWTRidget.this.focusable && AbstractSWTRidget.this.isOutputOnly()) {
                this.clickToFocus = true;
                ((Control)e.widget).setFocus();
            }
        }

        private boolean isFocusable() {
            return AbstractSWTRidget.this.focusable && !AbstractSWTRidget.this.isOutputOnly() || this.clickToFocus;
        }

        private Control findFocusTarget(Control control, Control[] controls) {
            Control candidate;
            int myIndex = -1;
            int i = 0;
            while (myIndex == -1 && i < controls.length) {
                if (controls[i] == control) {
                    myIndex = i;
                }
                ++i;
            }
            int result = -1;
            int i2 = myIndex + 1;
            while (result == -1 && i2 < controls.length) {
                candidate = controls[i2];
                if (this.canGetFocus(candidate)) {
                    result = i2;
                }
                ++i2;
            }
            i2 = 0;
            while (result == -1 && i2 < myIndex) {
                candidate = controls[i2];
                if (this.canGetFocus(candidate)) {
                    result = i2;
                }
                ++i2;
            }
            return result != -1 ? controls[result] : null;
        }

        private boolean canGetFocus(Control control) {
            if (!control.isEnabled()) {
                return false;
            }
            if (!control.isVisible()) {
                return false;
            }
            return (control.getStyle() & 8) == 0;
        }
    }
}

