/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt.views;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;
import org.eclipse.riena.ui.ridgets.swt.views.AbstractControlledView;
import org.eclipse.riena.ui.swt.RienaWindowRenderer;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDialogView
extends Dialog {
    private static final LnFUpdater LNF_UPDATER = new LnFUpdater();
    private final RienaWindowRenderer dlgRenderer = new RienaWindowRenderer((Window)this);
    private final ControlledView controlledView = new ControlledView();
    private String title = "";
    private boolean isClosing;

    private static Shell getShellByGuessing() {
        Shell result = null;
        if (PlatformUI.isWorkbenchRunning()) {
            result = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        } else if (Display.getCurrent() != null) {
            result = Display.getCurrent().getActiveShell();
        }
        return result;
    }

    protected AbstractDialogView(Shell parentShell) {
        super(parentShell != null ? parentShell : AbstractDialogView.getShellByGuessing());
        this.controlledView.setController(this.createController());
    }

    public void create() {
        this.setShellStyle(this.dlgRenderer.computeShellStyle());
        super.create();
        this.applyTitle(this.getShell());
        this.addUIControls((Composite)this.getShell());
        this.bindController();
        LNF_UPDATER.updateUIControlsAfterBind((Composite)this.getShell());
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!AbstractDialogView.this.isClosing) {
                    AbstractDialogView.this.close();
                }
            }
        });
    }

    public boolean close() {
        this.isClosing = true;
        AbstractWindowController controller = this.getController();
        this.setReturnCode(controller.getReturnCode());
        this.controlledView.unbind(controller);
        return super.close();
    }

    public final AbstractWindowController getController() {
        return (AbstractWindowController)this.controlledView.getController();
    }

    public final void setTitle(String title) {
        Assert.isNotNull((Object)title);
        this.title = title;
    }

    public final void build() {
        this.open();
    }

    protected final void addUIControl(Object uiControl, String bindingId) {
        this.controlledView.addUIControl(uiControl, bindingId);
    }

    protected final Control createButtonBar(Composite parent) {
        return this.dlgRenderer.createButtonBar(parent);
    }

    protected final Control createContents(Composite parent) {
        Control result = this.dlgRenderer.createContents(parent);
        super.createContents(this.dlgRenderer.getCenterComposite());
        return result;
    }

    protected final Control createDialogArea(Composite parent) {
        Control result = this.buildView(parent);
        this.addUIControl(this.getShell(), "windowRidget");
        LNF_UPDATER.updateUIControls(parent);
        return result;
    }

    protected abstract Control buildView(Composite var1);

    protected abstract AbstractWindowController createController();

    private void applyTitle(Shell shell) {
        if (shell.getText().length() == 0) {
            shell.setText(this.title);
        }
    }

    private void addUIControls(Composite composite) {
        Control[] controls;
        Control[] controlArray = controls = composite.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Control uiControl;
                block5: {
                    uiControl = controlArray[n2];
                    String bindingProperty = SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)uiControl);
                    if (StringUtils.isEmpty((CharSequence)bindingProperty)) break block5;
                    if (this.isChildOfComplexComponent(uiControl)) break block6;
                    this.addUIControl(uiControl, bindingProperty);
                }
                if (uiControl instanceof Composite) {
                    this.addUIControls((Composite)uiControl);
                }
            }
            ++n2;
        }
    }

    private void bindController() {
        this.controlledView.initialize(this.getController());
        this.controlledView.bind(this.getController());
    }

    private boolean isChildOfComplexComponent(Control uiControl) {
        if (uiControl.getParent() == null) {
            return false;
        }
        if (uiControl.getParent() instanceof IComplexComponent) {
            return true;
        }
        return this.isChildOfComplexComponent((Control)uiControl.getParent());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ControlledView
    extends AbstractControlledView<AbstractWindowController> {
        private ControlledView() {
        }

        @Override
        protected void addUIControl(Object uiControl, String propertyName) {
            super.addUIControl(uiControl, propertyName);
        }

        @Override
        protected void setController(AbstractWindowController controller) {
            super.setController(controller);
        }
    }
}

