/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.beans.common.TestBean;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISimpleNavigationNodeListener;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.SimpleNavigationNodeAdapter;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.AttentionMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ICompositeTableRidget;
import org.eclipse.riena.ui.ridgets.IDateTextRidget;
import org.eclipse.riena.ui.ridgets.IDateTimeRidget;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.IGroupedTreeTableRidget;
import org.eclipse.riena.ui.ridgets.IListRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.INumericTextRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRowRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree2.TreeNode;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MarkerSubModuleController
extends SubModuleController {
    public void configureRidgets() {
        final ITextRidget textName = (ITextRidget)this.getRidget("textName");
        textName.setText("Chateau Schaedelbrummer");
        final IDecimalTextRidget textPrice = (IDecimalTextRidget)this.getRidget("textPrice");
        textPrice.setGrouping(true);
        textPrice.setText(NumberFormat.getInstance().format(-29.99));
        final INumericTextRidget textAmount = (INumericTextRidget)this.getRidget("textAmount");
        textAmount.setSigned(false);
        textAmount.setGrouping(true);
        textAmount.setText("1001");
        final IDateTextRidget textDate = (IDateTextRidget)this.getRidget("textDate");
        textDate.setFormat("dd.MM.yyyy");
        textDate.setText("04.12.2008");
        IDateTimeRidget dtDate = (IDateTimeRidget)this.getRidget("dtDate");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        try {
            Date date = dateFormat.parse("04.12.2008");
            dtDate.setDate(date);
        }
        catch (ParseException parseException) {
            dtDate.setDate(new Date());
        }
        final IComboRidget comboAge = (IComboRidget)this.getRidget("comboAge");
        List<String> ages = Arrays.asList("<none>", "young", "moderate", "aged", "old");
        comboAge.bindToModel((IObservableList)new WritableList(ages, String.class), String.class, null, (IObservableValue)new WritableValue());
        comboAge.updateFromModel();
        comboAge.setEmptySelectionItem((Object)"<none>");
        comboAge.setSelection(1);
        final ISingleChoiceRidget choiceType = (ISingleChoiceRidget)this.getRidget("choiceType");
        choiceType.bindToModel(Arrays.asList("red", "white", "rose"), null, (Object)new TestBean(), "property");
        choiceType.updateFromModel();
        choiceType.setSelection((Object)"red");
        final IMultipleChoiceRidget choiceFlavor = (IMultipleChoiceRidget)this.getRidget("choiceFlavor");
        choiceFlavor.bindToModel(Arrays.asList("dry", "sweet", "sour", "spicy"), null, (Object)new TestBean(), "property");
        choiceFlavor.updateFromModel();
        choiceFlavor.setSelection(Arrays.asList("dry"));
        final IListRidget listPersons = (IListRidget)this.getRidget("listPersons");
        listPersons.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        listPersons.bindToModel((IObservableList)this.createPersonList(), Person.class, "listEntry");
        listPersons.updateFromModel();
        final ITableRidget tablePersons = (ITableRidget)this.getRidget("tablePersons");
        tablePersons.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        String[] colValues = new String[]{"lastname", "firstname"};
        String[] colHeaders = new String[]{"Last Name", "First Name"};
        tablePersons.bindToModel((IObservableList)this.createPersonList(), Person.class, colValues, colHeaders);
        tablePersons.updateFromModel();
        final ICompositeTableRidget compTable = (ICompositeTableRidget)this.getRidget("compTable");
        WritableList input = new WritableList(PersonFactory.createPersonList(), Person.class);
        compTable.bindToModel((IObservableList)input, Person.class, RowRidget.class);
        compTable.updateFromModel();
        final ITreeRidget treePersons = (ITreeRidget)this.getRidget("treePersons");
        treePersons.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        treePersons.bindToModel((Object[])this.createTreeRoots(), ITreeNode.class, "children", "parent", "value");
        treePersons.updateFromModel();
        final IGroupedTreeTableRidget treeWCols = (IGroupedTreeTableRidget)this.getRidget("treeWCols");
        treeWCols.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        treeWCols.setGroupingEnabled(true);
        colValues = new String[]{"word", "ACount"};
        colHeaders = new String[]{"Word", "#A"};
        treeWCols.bindToModel((Object[])this.createTreeTableRoots(), WordNode.class, "children", "parent", colValues, colHeaders);
        treeWCols.updateFromModel();
        final IToggleButtonRidget buttonToggle = (IToggleButtonRidget)this.getRidget("buttonToggle");
        buttonToggle.setText("Toggle");
        buttonToggle.setSelected(true);
        IActionRidget buttonPush = (IActionRidget)this.getRidget("buttonPush");
        final IToggleButtonRidget buttonRadioA = (IToggleButtonRidget)this.getRidget("buttonRadioA");
        final IToggleButtonRidget buttonRadioB = (IToggleButtonRidget)this.getRidget("buttonRadioB");
        final IToggleButtonRidget buttonCheck = (IToggleButtonRidget)this.getRidget("buttonCheck");
        final IRidget[] markables = new IRidget[]{textName, textPrice, textAmount, textDate, dtDate, comboAge, choiceType, choiceFlavor, listPersons, tablePersons, compTable, treePersons, treeWCols, buttonToggle, buttonPush, buttonRadioA, buttonRadioB, buttonCheck};
        final IToggleButtonRidget checkMandatory = (IToggleButtonRidget)this.getRidget("checkMandatory");
        final IToggleButtonRidget checkError = (IToggleButtonRidget)this.getRidget("checkError");
        IToggleButtonRidget checkDisabled = (IToggleButtonRidget)this.getRidget("checkDisabled");
        IToggleButtonRidget checkOutput = (IToggleButtonRidget)this.getRidget("checkOutput");
        IToggleButtonRidget checkHidden = (IToggleButtonRidget)this.getRidget("checkHidden");
        IToggleButtonRidget checkHiddenParent = (IToggleButtonRidget)this.getRidget("checkHiddenParent");
        checkMandatory.setText("&mandatory");
        checkMandatory.addListener(new IActionListener(){

            public void callback() {
                boolean isMandatory = checkMandatory.isSelected();
                IRidget[] iRidgetArray = markables;
                int n = markables.length;
                int n2 = 0;
                while (n2 < n) {
                    IRidget ridget = iRidgetArray[n2];
                    if (ridget instanceof IMarkableRidget) {
                        ((IMarkableRidget)ridget).setMandatory(isMandatory);
                    } else {
                        String name = ridget.getClass().getSimpleName();
                        System.out.println("No mandatory marker support on " + name);
                    }
                    ++n2;
                }
                if (isMandatory) {
                    textName.setText("");
                    textPrice.setText("");
                    textAmount.setText(null);
                    textDate.setText(null);
                    comboAge.setSelection((Object)"<none>");
                    choiceType.setSelection(null);
                    choiceFlavor.setSelection(null);
                    listPersons.setSelection(null);
                    tablePersons.setSelection(null);
                    compTable.clearSelection();
                    treePersons.setSelection(null);
                    treeWCols.setSelection(null);
                    buttonToggle.setSelected(false);
                    buttonRadioA.setSelected(false);
                    buttonRadioB.setSelected(false);
                    buttonCheck.setSelected(false);
                }
            }
        });
        checkError.setText("&error");
        checkError.addListener(new IActionListener(){
            private IValidator alwaysWrong = new AlwaysWrongValidator();

            public void callback() {
                boolean isError = checkError.isSelected();
                IRidget[] iRidgetArray = markables;
                int n = markables.length;
                int n2 = 0;
                while (n2 < n) {
                    IRidget ridget = iRidgetArray[n2];
                    if (ridget instanceof IMarkableRidget) {
                        ((IMarkableRidget)ridget).setErrorMarked(isError);
                    }
                    ++n2;
                }
                if (isError) {
                    textName.addValidationRule(this.alwaysWrong, ValidationTime.ON_UI_CONTROL_EDIT);
                    textPrice.addValidationRule(this.alwaysWrong, ValidationTime.ON_UI_CONTROL_EDIT);
                    textAmount.addValidationRule(this.alwaysWrong, ValidationTime.ON_UI_CONTROL_EDIT);
                    textDate.addValidationRule(this.alwaysWrong, ValidationTime.ON_UI_CONTROL_EDIT);
                } else {
                    textName.removeValidationRule(this.alwaysWrong);
                    textPrice.removeValidationRule(this.alwaysWrong);
                    textAmount.removeValidationRule(this.alwaysWrong);
                    textDate.removeValidationRule(this.alwaysWrong);
                }
            }
        });
        checkDisabled.setText("&disabled");
        checkDisabled.addListener((IActionListener)new DisabledActionListener(markables, checkDisabled));
        checkOutput.setText("&output");
        checkOutput.addListener((IActionListener)new OutputActionListener(markables, checkOutput));
        checkHidden.setText("&hidden");
        checkHidden.addListener((IActionListener)new HiddenActionListener(checkHidden, markables));
        checkHiddenParent.setText("&hidden parent");
        checkHiddenParent.addListener((IActionListener)new HiddenParentActionListener(checkHiddenParent, markables));
        ((ISubModuleNode)this.getNavigationNode()).addSimpleListener((ISimpleNavigationNodeListener)new SimpleNavigationNodeAdapter(){

            public void afterDeactivated(INavigationNode<?> node) {
                super.afterDeactivated(node);
                Collection markers = node.getMarkersOfType(AttentionMarker.class);
                for (AttentionMarker marker : markers) {
                    node.removeMarker((IMarker)marker);
                }
            }
        });
    }

    private WritableList createPersonList() {
        return new WritableList(PersonFactory.createPersonList(), Person.class);
    }

    private ITreeNode[] createTreeRoots() {
        TreeNode rootA = new TreeNode((Object)"A");
        new TreeNode((ITreeNode)rootA, (Object)new Person("Albinus", "Albert"));
        new TreeNode((ITreeNode)rootA, (Object)new Person("Aurelius", "Mark"));
        TreeNode rootB = new TreeNode((Object)"B");
        new TreeNode((ITreeNode)rootB, (Object)new Person("Barker", "Clyve"));
        new TreeNode((ITreeNode)rootB, (Object)new Person("Barclay", "Bob"));
        return new ITreeNode[]{rootA, rootB};
    }

    private WordNode[] createTreeTableRoots() {
        WordNode rootA = new WordNode("A");
        WordNode rootB = new WordNode("B");
        new WordNode(rootA, "Astoria");
        new WordNode(rootA, "Ashland");
        new WordNode(rootA, "Aurora");
        new WordNode(rootA, "Alpine");
        new WordNode(rootB, "Boring");
        new WordNode(rootB, "Bend");
        new WordNode(rootB, "Beaverton");
        new WordNode(rootB, "Bridgeport");
        return new WordNode[]{rootA, rootB};
    }

    private static final class AlwaysWrongValidator
    implements IValidator {
        private AlwaysWrongValidator() {
        }

        public IStatus validate(Object value) {
            return ValidationRuleStatus.error((boolean)false, (String)"");
        }
    }

    private static final class DisabledActionListener
    implements IActionListener {
        private final IRidget[] markables;
        private final IToggleButtonRidget checkDisabled;

        private DisabledActionListener(IRidget[] markables, IToggleButtonRidget checkDisabled) {
            this.markables = markables;
            this.checkDisabled = checkDisabled;
        }

        public void callback() {
            boolean isEnabled = !this.checkDisabled.isSelected();
            IRidget[] iRidgetArray = this.markables;
            int n = this.markables.length;
            int n2 = 0;
            while (n2 < n) {
                IRidget ridget = iRidgetArray[n2];
                ridget.setEnabled(isEnabled);
                ++n2;
            }
        }
    }

    private static final class HiddenActionListener
    implements IActionListener {
        private final IToggleButtonRidget checkHidden;
        private final IRidget[] markables;

        private HiddenActionListener(IToggleButtonRidget checkHidden, IRidget[] markables) {
            this.checkHidden = checkHidden;
            this.markables = markables;
        }

        public void callback() {
            boolean isVisible = !this.checkHidden.isSelected();
            IRidget[] iRidgetArray = this.markables;
            int n = this.markables.length;
            int n2 = 0;
            while (n2 < n) {
                IRidget ridget = iRidgetArray[n2];
                ridget.setVisible(isVisible);
                ++n2;
            }
        }
    }

    private static final class HiddenParentActionListener
    implements IActionListener {
        private final IToggleButtonRidget checkHiddenParent;
        private final IRidget[] markables;

        private HiddenParentActionListener(IToggleButtonRidget checkHiddenParent, IRidget[] markables) {
            this.checkHiddenParent = checkHiddenParent;
            this.markables = markables;
        }

        public void callback() {
            Composite parent = ((Control)this.markables[0].getUIControl()).getParent();
            boolean isVisible = !this.checkHiddenParent.isSelected();
            parent.setVisible(isVisible);
        }
    }

    private static final class OutputActionListener
    implements IActionListener {
        private final IRidget[] markables;
        private final IToggleButtonRidget checkOutput;

        private OutputActionListener(IRidget[] markables, IToggleButtonRidget checkOutput) {
            this.markables = markables;
            this.checkOutput = checkOutput;
        }

        public void callback() {
            boolean isOutput = this.checkOutput.isSelected();
            IRidget[] iRidgetArray = this.markables;
            int n = this.markables.length;
            int n2 = 0;
            while (n2 < n) {
                IRidget ridget = iRidgetArray[n2];
                if (ridget instanceof IMarkableRidget) {
                    ((IMarkableRidget)ridget).setOutputOnly(isOutput);
                } else {
                    String name = ridget.getClass().getSimpleName();
                    System.out.println("No output marker support on " + name);
                }
                ++n2;
            }
        }
    }

    public static final class RowRidget
    extends AbstractCompositeRidget
    implements IRowRidget {
        private Person rowData;

        public void setData(Object rowData) {
            this.rowData = (Person)rowData;
        }

        public void configureRidgets() {
            ITextRidget txtLast = (ITextRidget)this.getRidget("txtLast");
            txtLast.bindToModel((Object)this.rowData, "firstname");
            txtLast.updateFromModel();
            ITextRidget txtFirst = (ITextRidget)this.getRidget("txtFirst");
            txtFirst.bindToModel((Object)this.rowData, "firstname");
            txtFirst.updateFromModel();
        }
    }
}

