/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.tools;

import java.util.Map;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.tools.Activator;
import org.eclipse.equinox.internal.p2.updatechecker.UpdateChecker;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateChecker;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.osgi.framework.BundleContext;

public class UpdateCheckerApplication
implements IApplication {
    private static String ARG_PROFILE = "-profile";
    private static String ARG_POLL = "-poll";
    private static String ARG_DELAY = "-delay";
    private static String ARG_DEBUG = "-debug";
    private static String ARG_TRACE = "-trace";
    String profileId;
    long delay = -1L;
    long poll = -1L;
    IUpdateChecker checker;
    IUpdateListener listener = new IUpdateListener(){

        public void updatesAvailable(UpdateEvent event) {
            System.out.println("Updates available for " + UpdateCheckerApplication.this.profileId);
            IInstallableUnit[] ius = event.getIUs();
            int i = 0;
            while (i < ius.length) {
                System.out.println(ius[i].toString());
                ++i;
            }
        }
    };

    public Object start(IApplicationContext context) throws Exception {
        this.checker = (IUpdateChecker)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IUpdateChecker.SERVICE_NAME);
        if (this.checker == null) {
            throw new RuntimeException("Update checker could not be loaded.");
        }
        Map args = context.getArguments();
        this.initializeFromArguments((String[])args.get("application.args"));
        if (this.profileId == null) {
            System.out.println("Must specify a profile id using -profile arg");
        } else {
            this.checker.addUpdateCheck(this.profileId, (Query)InstallableUnitQuery.ANY, this.delay, this.poll, this.listener);
        }
        return null;
    }

    public void stop() {
        this.checker.removeUpdateCheck(this.listener);
    }

    public void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(ARG_DEBUG)) {
                UpdateChecker.DEBUG = true;
            } else if (args[i].equals(ARG_TRACE)) {
                UpdateChecker.TRACE = true;
            }
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(ARG_PROFILE)) {
                    this.profileId = arg;
                } else if (args[i - 1].equalsIgnoreCase(ARG_POLL)) {
                    this.poll = this.getLong(ARG_POLL, arg, -1L);
                } else if (args[i - 1].equalsIgnoreCase(ARG_DELAY)) {
                    this.delay = this.getLong(ARG_DELAY, arg, -1L);
                }
            }
            ++i;
        }
    }

    long getLong(String argName, String value, long defaultValue) {
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception exception) {
                System.out.println("The value for " + argName + "(" + value + ") is not a long.");
            }
        }
        return defaultValue;
    }
}

