/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.tools.mirror;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.tools.mirror.RepositoryMirroring;

public class MirrorApplication
implements IApplication {
    private static final String EMPTY_STRING = "";
    private static final String COMMA_SEPARATOR = ",";
    private String[] iuSpecs;
    private String[] artifactSpecs;
    private URI metadataSourceLocation;
    private URI metadataDestinationLocation;
    private URI artifactSourceLocation;
    private URI artifactDestinationLocation;
    private boolean referencedIUs = false;
    private boolean raw = false;
    private boolean overwrite = false;
    private boolean verbose = false;
    private boolean compressed = false;

    public static String[] getArrayArgsFromString(String list, String separator) {
        if (list == null || list.trim().equals(EMPTY_STRING)) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals(EMPTY_STRING)) continue;
            if ((token.indexOf(91) >= 0 || token.indexOf(40) >= 0) && tokens.hasMoreTokens()) {
                result.add(String.valueOf(token) + separator + tokens.nextToken());
                continue;
            }
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    private static String[] getArrayArgsFromString(String list, String delimiterStart, String delimiterEnd, String separator) {
        if (list == null || list.trim().equals(EMPTY_STRING)) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, delimiterStart);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.endsWith(delimiterEnd)) {
                token = token.substring(0, token.length() - delimiterEnd.length());
            }
            if (token.endsWith(String.valueOf(delimiterEnd) + separator)) {
                token = token.substring(0, token.length() - delimiterEnd.length() - separator.length());
            }
            if (token.equals(EMPTY_STRING)) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public Object start(IApplicationContext context) throws Exception {
        long time = -System.currentTimeMillis();
        this.initializeFromArguments((String[])context.getArguments().get("application.args"));
        RepositoryMirroring operation = new RepositoryMirroring(this.metadataSourceLocation, this.metadataDestinationLocation, this.artifactSourceLocation, this.artifactDestinationLocation, this.overwrite, this.compressed);
        operation.setReferencedIUs(this.referencedIUs);
        operation.setRaw(this.raw);
        operation.setVerbose(this.verbose);
        operation.mirror(this.iuSpecs, this.artifactSpecs);
        time += System.currentTimeMillis();
        if (this.verbose) {
            System.out.println("Operation completed in " + new Long(time) + " ms.");
        }
        return IApplication.EXIT_OK;
    }

    public void stop() {
    }

    public void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-referencedIUs")) {
                this.referencedIUs = true;
            }
            if (args[i].equalsIgnoreCase("-raw")) {
                this.raw = true;
            }
            if (args[i].equalsIgnoreCase("-overwrite")) {
                this.overwrite = true;
            }
            if (args[i].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
            }
            if (args[i].equalsIgnoreCase("-compressed")) {
                this.compressed = true;
            }
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                try {
                    if (args[i - 1].equalsIgnoreCase("-source")) {
                        this.metadataSourceLocation = URIUtil.fromString((String)arg);
                        this.artifactSourceLocation = URIUtil.fromString((String)arg);
                    }
                    if (args[i - 1].equalsIgnoreCase("-destination")) {
                        this.metadataDestinationLocation = URIUtil.fromString((String)arg);
                        this.artifactDestinationLocation = URIUtil.fromString((String)arg);
                    }
                    if (args[i - 1].equalsIgnoreCase("-metadatadestination")) {
                        this.metadataDestinationLocation = URIUtil.fromString((String)arg);
                    }
                    if (args[i - 1].equalsIgnoreCase("-metadatasource")) {
                        this.metadataSourceLocation = URIUtil.fromString((String)arg);
                    }
                    if (args[i - 1].equalsIgnoreCase("-artifactdestination")) {
                        this.artifactDestinationLocation = URIUtil.fromString((String)arg);
                    }
                    if (args[i - 1].equalsIgnoreCase("-artifactsource")) {
                        this.artifactSourceLocation = URIUtil.fromString((String)arg);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException("Repository location (" + arg + ") must be a URL.");
                }
                if (args[i - 1].equalsIgnoreCase("-ius")) {
                    this.iuSpecs = arg.equalsIgnoreCase("all") ? new String[0] : MirrorApplication.getArrayArgsFromString(arg, COMMA_SEPARATOR);
                }
                if (args[i - 1].equalsIgnoreCase("-artifacts")) {
                    this.artifactSpecs = arg.equalsIgnoreCase("all") ? new String[0] : MirrorApplication.getArrayArgsFromString(arg, "{", "}", COMMA_SEPARATOR);
                }
            }
            ++i;
        }
    }
}

