/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizerLocator;
import org.eclipse.riena.ui.core.uiprocess.UICallbackDispatcher;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;

public class ProgressProviderBridge
extends ProgressProvider {
    private static ProgressProviderBridge instance;
    private IProgressVisualizerLocator visualizerFactory;
    private Map<Job, UIProcess> jobUiProcess = new HashMap<Job, UIProcess>();

    public static ProgressProviderBridge instance() {
        if (instance == null) {
            instance = new ProgressProviderBridge();
        }
        return instance;
    }

    public void setVisualizerFactory(IProgressVisualizerLocator visualizerFactory) {
        this.visualizerFactory = visualizerFactory;
    }

    public IProgressMonitor createMonitor(Job job) {
        ProgressProvider provider = this.queryProgressProvider(job);
        return provider.createMonitor(job);
    }

    private ProgressProvider queryProgressProvider(Job job) {
        UIProcess uiprocess = this.jobUiProcess.get(job);
        Object context = this.getContext(job);
        if (uiprocess == null) {
            uiprocess = this.createDefaultUIProcess(job);
        }
        UICallbackDispatcher dispatcher = (UICallbackDispatcher)uiprocess.getAdapter(UICallbackDispatcher.class);
        dispatcher.addUIMonitor(this.visualizerFactory.getProgressVisualizer(context));
        return dispatcher;
    }

    private Object getContext(Job job) {
        return job.getProperty(UIProcess.PROPERTY_CONTEXT);
    }

    private UIProcess createDefaultUIProcess(Job job) {
        return new UIProcess(job);
    }

    public void registerMapping(Job job, UIProcess process) {
        this.jobUiProcess.put(job, process);
    }
}

