/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.internal.ui.core.Activator;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitor;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitorContainer;
import org.eclipse.riena.ui.core.uiprocess.IUISynchronizer;
import org.eclipse.riena.ui.core.uiprocess.ProcessInfo;
import org.eclipse.riena.ui.core.uiprocess.ProgressProviderBridge;
import org.eclipse.riena.ui.core.uiprocess.UICallbackDispatcher;
import org.eclipse.riena.ui.core.uiprocess.UISynchronizer;
import org.osgi.framework.BundleContext;

public class UIProcess
extends PlatformObject
implements IUIMonitor {
    public static final QualifiedName PROPERTY_CONTEXT = new QualifiedName("uiProcess", "context");
    private final UICallbackDispatcher callbackDispatcher;
    private final Job job;

    public UIProcess(String name) {
        this(name, false);
    }

    public UIProcess(String name, boolean user) {
        this(name, user, new Object());
    }

    public UIProcess(String name, boolean user, Object context) {
        this(name, UISynchronizer.createSynchronizer(), user, context);
    }

    public UIProcess(String name, IUISynchronizer syncher, boolean user, Object context) {
        this(name, new UICallbackDispatcher(syncher), user, context);
    }

    private UIProcess(String name, UICallbackDispatcher dispatcher, boolean user, Object context) {
        this.callbackDispatcher = dispatcher;
        this.job = this.createJob(name, user, context);
        this.configure();
    }

    public UIProcess(Job job) {
        this.callbackDispatcher = new UICallbackDispatcher(UISynchronizer.createSynchronizer());
        this.job = job;
        this.configure();
    }

    @Deprecated
    public static IUISynchronizer getSynchronizerFromExtensionPoint() {
        return UISynchronizer.createSynchronizer();
    }

    private void configure() {
        this.register();
        this.configureProcessInfo();
    }

    private void configureProcessInfo() {
        if (this.callbackDispatcher != null) {
            ProcessInfo processInfo = this.callbackDispatcher.getProcessInfo();
            processInfo.setContext(this.job.getProperty(PROPERTY_CONTEXT));
            processInfo.addPropertyChangeListener(new CancelListener());
            processInfo.setDialogVisible(this.job.isUser());
            processInfo.setNote(this.job.getName());
            processInfo.setTitle(this.job.getName());
        }
    }

    private Job createJob(String name, boolean user, Object context) {
        InternalJob newJob = new InternalJob(name);
        newJob.setUser(user);
        newJob.setProperty(PROPERTY_CONTEXT, context);
        return newJob;
    }

    protected boolean forceMonitorBegin() {
        return true;
    }

    protected Job getJob() {
        return this.job;
    }

    protected void beforeRun(IProgressMonitor monitor) {
    }

    protected void afterRun(IProgressMonitor monitor) {
    }

    protected int getTotalWork() {
        return 0;
    }

    private void register() {
        this.callbackDispatcher.addUIMonitor(this);
        ProgressProviderBridge.instance().registerMapping(this.job, this);
    }

    public UICallbackDispatcher getCallbackDispatcher() {
        return this.callbackDispatcher;
    }

    public void updateProgress(int progress) {
    }

    public void initialUpdateUI(int totalWork) {
    }

    public void finalUpdateUI() {
    }

    public boolean runJob(IProgressMonitor monitor) {
        return true;
    }

    public void start() {
        this.job.schedule();
    }

    public Object getAdapter(Class adapter) {
        Object adapted = super.getAdapter(adapter);
        if (adapted == null) {
            if (adapter.isInstance(this)) {
                adapted = this;
            }
            if (adapter.equals(UICallbackDispatcher.class)) {
                adapted = this.getCallbackDispatcher();
            }
        }
        return adapted;
    }

    public void setNote(String note) {
        this.getProcessInfo().setNote(note);
    }

    public void setTitle(String title) {
        this.getProcessInfo().setTitle(title);
    }

    public void setIcon(String icon) {
        this.getProcessInfo().setIcon(icon);
    }

    private ProcessInfo getProcessInfo() {
        return this.getCallbackDispatcher().getProcessInfo();
    }

    public boolean isActive(IUIMonitorContainer container) {
        return true;
    }

    protected void notifyUpdateUI() {
        this.getCallbackDispatcher().getSyncher().synchronize(new Runnable(){

            public void run() {
                try {
                    UIProcess.this.updateUi();
                }
                catch (Exception e) {
                    ((IExceptionHandlerManager)Service.get((BundleContext)Activator.getDefault().getContext(), IExceptionHandlerManager.class)).handleException((Throwable)e);
                }
            }
        });
    }

    public void updateUi() {
    }

    private final class CancelListener
    implements PropertyChangeListener {
        private CancelListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("cancel".equals(event.getPropertyName())) {
                UIProcess.this.job.cancel();
            }
        }
    }

    private final class InternalJob
    extends Job {
        public InternalJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            UIProcess.this.beforeRun(monitor);
            if (UIProcess.this.forceMonitorBegin()) {
                monitor.beginTask(this.getName(), UIProcess.this.getTotalWork());
            }
            boolean state = false;
            try {
                state = UIProcess.this.runJob(monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                if (!monitor.isCanceled()) {
                    monitor.setCanceled(true);
                }
            }
            catch (Throwable t) {
                ((IExceptionHandlerManager)Service.get((BundleContext)Activator.getDefault().getContext(), IExceptionHandlerManager.class)).handleException(t);
            }
            monitor.done();
            UIProcess.this.afterRun(monitor);
            return state ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }
    }
}

