/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.discovery;

import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.IRemoteServiceRegistry;
import org.eclipse.riena.communication.core.factory.IRemoteServiceFactory;
import org.eclipse.riena.communication.core.factory.RemoteServiceFactory;
import org.eclipse.riena.communication.core.publisher.IServicePublishEventDispatcher;
import org.eclipse.riena.core.RienaActivator;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.eclipse.riena.internal.communication.discovery.RemoteServiceDiscovery;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;

public class Activator
extends RienaActivator {
    private RemoteServiceDiscovery discovery;
    private ServiceInjector registryInjector;
    private IRemoteServiceRegistration servicePublisherReg;
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        RemoteServiceFactory factory = new RemoteServiceFactory();
        this.discovery = new RemoteServiceDiscovery(context);
        this.discovery.setRemoteServiceFactory(factory);
        this.registryInjector = Inject.service(IRemoteServiceRegistry.class).useRanking().into((Object)this.discovery).andStart(context);
        this.discovery.start();
        this.servicePublisherReg = factory.createAndRegisterProxy(IServicePublishEventDispatcher.class, "http://${riena.hostname}/hessian/ServicePublisherWS", "hessian", context);
        ProtocolNotifier protNotifier = new ProtocolNotifier();
        context.addServiceListener((ServiceListener)protNotifier, "(objectClass=" + IRemoteServiceFactory.class.getName() + ")");
        this.discovery.update();
    }

    public void stop(BundleContext context) throws Exception {
        this.discovery.stop();
        this.registryInjector.stop();
        if (this.servicePublisherReg != null) {
            this.servicePublisherReg.unregister();
        }
        this.discovery = null;
        this.registryInjector = null;
        this.servicePublisherReg = null;
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    class ProtocolNotifier
    implements ServiceListener {
        ProtocolNotifier() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                String protocol = (String)event.getServiceReference().getProperty("riena.protocol");
                Activator.this.discovery.checkForUnpublishedServices(protocol);
            }
        }
    }
}

