/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.extension;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.injector.IStoppable;
import org.eclipse.riena.core.injector.InjectionFailure;
import org.eclipse.riena.core.injector.extension.ExtensionDescriptor;
import org.eclipse.riena.core.injector.extension.ExtensionInterface;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.injector.extension.ExtensionMapper;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionInjector
implements IStoppable {
    public static final String RIENA_EXTENSIONS_DONOTWIRE_SYSTEM_PROPERTY = "riena.extensions.donotwire";
    private final ExtensionDescriptor extensionDesc;
    private final Object target;
    private boolean started;
    private boolean symbolReplace = true;
    private boolean nonSpecific = true;
    private String updateMethodName = "update";
    private Method updateMethod;
    private IRegistryEventListener injectorListener;
    private boolean isArray;
    private Class<?> componentType;
    private static final String DEFAULT_UPDATE_METHOD_NAME = "update";
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ExtensionInjector.class);

    ExtensionInjector(ExtensionDescriptor extensionDesc, Object target) {
        this.extensionDesc = extensionDesc;
        this.target = target;
    }

    public ExtensionInjector andStart(BundleContext context) {
        Assert.isTrue((!this.started ? 1 : 0) != 0, (String)"ExtensionInjector already started.");
        this.started = true;
        this.updateMethod = this.findUpdateMethod();
        Class<?> parameterType = this.updateMethod.getParameterTypes()[0];
        this.isArray = parameterType.isArray();
        this.componentType = this.extensionDesc.getInterfaceType() != null ? this.extensionDesc.getInterfaceType() : (this.isArray ? parameterType.getComponentType() : parameterType);
        this.extensionDesc.getExtensionPointId().normalize(this.componentType);
        this.populateInterfaceBeans(true);
        IExtensionRegistry extensionRegistry = RegistryFactory.getRegistry();
        Assert.isLegal((extensionRegistry != null ? 1 : 0) != 0, (String)"For some reason the extension registry has not been created. Injecting extensions is not possible.");
        this.injectorListener = new InjectorListener();
        for (String id : this.extensionDesc.getExtensionPointId().compatibleIds()) {
            extensionRegistry.addListener(this.injectorListener, id);
        }
        return this;
    }

    public ExtensionInjector update(String updateMethodName) {
        Assert.isNotNull((Object)updateMethodName, (String)"Update method name must not be null");
        Assert.isTrue((!this.started ? 1 : 0) != 0, (String)"ExtensionInjector already started.");
        this.updateMethodName = updateMethodName;
        return this;
    }

    public ExtensionInjector specific() {
        Assert.isTrue((!this.started ? 1 : 0) != 0, (String)"ExtensionInjector already started.");
        this.nonSpecific = false;
        return this;
    }

    public ExtensionInjector doNotReplaceSymbols() {
        Assert.isTrue((!this.started ? 1 : 0) != 0, (String)"ExtensionInjector already started.");
        this.symbolReplace = false;
        return this;
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        IExtensionRegistry extensionRegistry = RegistryFactory.getRegistry();
        if (extensionRegistry == null) {
            LOGGER.log(1, "For some reason the extension registry has been gone!");
        } else {
            extensionRegistry.removeListener(this.injectorListener);
        }
        Object emptyExtensions = this.isArray ? Array.newInstance(this.componentType, 0) : null;
        this.update(new Object[]{emptyExtensions});
        this.injectorListener = null;
    }

    private Method findUpdateMethod() {
        return this.extensionDesc.getInterfaceType() == null ? this.findUpdateMethodForUnkownType() : this.findUpdateMethodForKownType();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Method findUpdateMethodForKownType() {
        try {
            if (this.extensionDesc.requiresArrayUpdateMethod()) {
                return this.seekMatchingUpdateMethod(this.extensionDesc.getInterfaceType(), true);
            }
            {
                catch (NoSuchMethodException e) {
                    throw new InjectionFailure("Could not find 'bind' method " + this.updateMethodName + "(" + this.extensionDesc.getInterfaceType() + ").", e);
                }
                try {
                    return this.seekMatchingUpdateMethod(this.extensionDesc.getInterfaceType(), false);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                return this.seekMatchingUpdateMethod(this.extensionDesc.getInterfaceType(), true);
            }
        }
        catch (SecurityException e) {
            throw new InjectionFailure("Could not find 'bind' method " + this.updateMethodName + "(" + this.extensionDesc.getInterfaceType() + ").", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Method seekMatchingUpdateMethod(Class<?> interfaceType, boolean isArray) throws NoSuchMethodException {
        try {
            seeking = isArray != false ? Array.newInstance(interfaceType, 0).getClass() : interfaceType;
            return this.target.getClass().getMethod(this.updateMethodName, new Class[]{seeking});
        }
        catch (NoSuchMethodException v0) {
            var6_5 = interfaceType.getInterfaces();
            var5_6 = var6_5.length;
            var4_7 = 0;
            ** while (var4_7 < var5_6)
        }
lbl-1000:
        // 1 sources

        {
            superInterfaceType = var6_5[var4_7];
            attempt = this.seekMatchingUpdateMethod(superInterfaceType, isArray);
            if (attempt != null) {
                return attempt;
            }
            ++var4_7;
            continue;
        }
lbl15:
        // 1 sources

        throw new NoSuchMethodError("In " + this.target.getClass() + " is no method matching " + this.updateMethodName + "(" + interfaceType + (isArray != false ? "[]" : "") + " )");
    }

    private Method findUpdateMethodForUnkownType() {
        Method[] methods;
        ArrayList<Method> candidates = new ArrayList<Method>();
        Method[] methodArray = methods = this.target.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(this.updateMethodName) && method.getParameterTypes().length == 1 && this.isExtensionInterface(method.getParameterTypes()[0])) {
                candidates.add(method);
            }
            ++n2;
        }
        if (candidates.size() == 0) {
            throw new InjectionFailure("No suitable 'bind' method found. Looking for method " + this.updateMethodName + "(<someinterface>[]). someinterface must be annotated with @ExtensionInterface.");
        }
        if (candidates.size() == 1) {
            if (this.matchesExtensionPointConstraint(((Method)candidates.get(0)).getParameterTypes()[0])) {
                return (Method)candidates.get(0);
            }
            throw new InjectionFailure("Found method " + candidates.get(0) + " does not match extension point constraints (e.g. requires an array type).");
        }
        if (candidates.size() > 2) {
            throw new InjectionFailure("Too much (>2) candidates (" + candidates + ") for 'bind' method " + this.updateMethodName + ".");
        }
        if (this.matchesExtensionPointConstraint(((Method)candidates.get(0)).getParameterTypes()[0])) {
            return (Method)candidates.get(0);
        }
        if (this.matchesExtensionPointConstraint(((Method)candidates.get(1)).getParameterTypes()[0])) {
            return (Method)candidates.get(1);
        }
        throw new InjectionFailure("No suitable candidate from (" + candidates + ") found for 'bind' method " + this.updateMethodName + ".");
    }

    private boolean isExtensionInterface(Class<?> type) {
        Class<?> clazz = type = type.isArray() ? type.getComponentType() : type;
        return type.isInterface() && type.isAnnotationPresent(ExtensionInterface.class);
    }

    private boolean matchesExtensionPointConstraint(Class<?> type) {
        return !this.extensionDesc.requiresArrayUpdateMethod() || type.isArray();
    }

    void populateInterfaceBeans(boolean onStart) {
        try {
            ?[] beans = ExtensionMapper.map(this.symbolReplace, this.extensionDesc, this.componentType, this.nonSpecific);
            if (!this.matchesExtensionPointConstraint(beans.length)) {
                LOGGER.log(1, "Number of extensions " + beans.length + " does not fullfil the extension point's " + this.extensionDesc.getExtensionPointId() + " constraints.");
            }
            if (this.isArray) {
                this.update(new Object[]{beans});
            } else {
                this.update(new Object[]{beans.length > 0 ? beans[0] : null});
            }
        }
        catch (InjectionFailure e) {
            if (onStart) {
                throw e;
            }
            this.update(new Object[1]);
        }
    }

    private void update(Object[] params) {
        try {
            this.updateMethod.invoke(this.target, params);
        }
        catch (IllegalArgumentException e) {
            throw new InjectionFailure("Calling 'bind' method " + this.updateMethod + " failed.", e);
        }
        catch (IllegalAccessException e) {
            throw new InjectionFailure("Calling 'bind' method " + this.updateMethod + " failed.", e);
        }
        catch (InvocationTargetException e) {
            throw new InjectionFailure("Calling 'bind' method " + this.updateMethod + " failed.", e.getTargetException());
        }
    }

    private boolean matchesExtensionPointConstraint(int occurence) {
        return occurence >= this.extensionDesc.getMinOccurences() && occurence <= this.extensionDesc.getMaxOccurences();
    }

    private class InjectorListener
    implements IRegistryEventListener {
        private InjectorListener() {
        }

        public void added(IExtension[] extensions) {
            ExtensionInjector.this.populateInterfaceBeans(false);
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtension[] extensions) {
            ExtensionInjector.this.populateInterfaceBeans(false);
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }
    }
}

