/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.repository;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.repository.Activator;
import org.eclipse.equinox.internal.p2.repository.RepositoryStatusHelper;
import org.eclipse.equinox.internal.provisional.p2.core.IServiceUI;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.osgi.framework.BundleContext;

public class Credentials {
    private static final Map savedAuthInfo = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$0;

    public static IServiceUI.AuthenticationInfo forLocation(URI location, boolean prompt) throws LoginCanceledException, CoreException {
        return Credentials.forLocation(location, prompt, null);
    }

    public static IServiceUI.AuthenticationInfo forLocation(URI location, boolean prompt, IServiceUI.AuthenticationInfo lastUsed) throws LoginCanceledException, CoreException {
        String nodeKey;
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        String host = location.getHost();
        if (host == null) {
            String scheme = location.getScheme();
            host = URIUtil.isFileURI((URI)location) || scheme == null ? new Path(location.toString()).removeLastSegments(1).toString() : location.toString();
        }
        try {
            nodeKey = URLEncoder.encode(host, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                String enc = System.getProperty("file.encoding");
                if (enc == null) {
                    throw new UnsupportedEncodingException("No UTF-8 encoding and missing system property: file.encoding");
                }
                nodeKey = URLEncoder.encode(host, enc);
            }
            catch (UnsupportedEncodingException e) {
                throw RepositoryStatusHelper.internalError(e);
            }
        }
        String nodeName = "org.eclipse.equinox.p2.repository/" + nodeKey;
        ISecurePreferences prefNode = null;
        try {
            if (securePreferences.nodeExists(nodeName)) {
                prefNode = securePreferences.node(nodeName);
            }
        }
        catch (IllegalArgumentException e) {
            throw RepositoryStatusHelper.internalError(e);
        }
        catch (IllegalStateException e) {
            throw RepositoryStatusHelper.internalError(e);
        }
        if (!prompt) {
            try {
                if (prefNode != null) {
                    String username = prefNode.get("username", null);
                    String password = prefNode.get("password", null);
                    if (username != null && password != null) {
                        return new IServiceUI.AuthenticationInfo(username, password, true);
                    }
                }
                return Credentials.restoreFromMemory(nodeName);
            }
            catch (StorageException e) {
                throw RepositoryStatusHelper.internalError(e);
            }
        }
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.IServiceUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IServiceUI adminUIService = (IServiceUI)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        IServiceUI.AuthenticationInfo loginDetails = null;
        if (adminUIService != null) {
            IServiceUI.AuthenticationInfo authenticationInfo = loginDetails = lastUsed != null ? adminUIService.getUsernamePassword(host, lastUsed) : adminUIService.getUsernamePassword(host);
        }
        if (loginDetails == null) {
            throw new LoginCanceledException();
        }
        if (loginDetails.saveResult()) {
            if (prefNode == null) {
                prefNode = securePreferences.node(nodeName);
            }
            try {
                prefNode.put("username", loginDetails.getUserName(), true);
                prefNode.put("password", loginDetails.getPassword(), true);
                prefNode.flush();
            }
            catch (StorageException e1) {
                throw RepositoryStatusHelper.internalError(e1);
            }
            catch (IOException e) {
                throw RepositoryStatusHelper.internalError(e);
            }
        }
        if (securePreferences.nodeExists(nodeName)) {
            prefNode = securePreferences.node(nodeName);
            prefNode.removeNode();
            try {
                prefNode.flush();
            }
            catch (IOException e) {
                throw RepositoryStatusHelper.internalError(e);
            }
        }
        Credentials.saveInMemory(nodeName, loginDetails);
        return loginDetails;
    }

    private static IServiceUI.AuthenticationInfo restoreFromMemory(String nodeName) {
        return (IServiceUI.AuthenticationInfo)savedAuthInfo.get(nodeName);
    }

    private static void saveInMemory(String nodeName, IServiceUI.AuthenticationInfo loginDetails) {
        savedAuthInfo.put(nodeName, loginDetails);
    }

    public static class LoginCanceledException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

