/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.attachment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import org.eclipse.riena.communication.core.attachment.Attachment;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class AttachmentTest
extends RienaTestCase {
    private Attachment attach;
    private File file;
    private static final int BUFFER_SIZE = 20;
    private static final String WRITE_BUFFER = "This text file is accessed in AttachmentTest to test the Attachment class.";
    private static final int FILE_SIZE = "This text file is accessed in AttachmentTest to test the Attachment class.".length();

    public void setUp() throws Exception {
        super.setUp();
        this.file = File.createTempFile("attachTest", null);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.file));
        printWriter.write(WRITE_BUFFER);
        printWriter.close();
        this.attach = new Attachment(this.file);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testConstruction() {
        AttachmentTest.assertTrue((String)"attachment does not have type FILE", ((Attachment.Type)ReflectionUtils.invokeHidden((Object)this.attach, (String)"getType", (Object[])new Object[0]) == Attachment.Type.FILE ? 1 : 0) != 0);
        AttachmentTest.assertTrue((String)"internal file object is not the passed parameter", ((File)ReflectionUtils.invokeHidden((Object)this.attach, (String)"getInternalFile", (Object[])new Object[0]) == this.file ? 1 : 0) != 0);
    }

    public void testReadAsStream() throws IOException {
        InputStream stream = null;
        try {
            stream = this.attach.readAsStream();
            int attachmentCounter = 0;
            int incCounter = 0;
            byte[] b = new byte[20];
            while ((incCounter = stream.read(b)) > 0) {
                attachmentCounter += incCounter;
            }
            stream = new FileInputStream(this.file);
            int physicalFileCounter = 0;
            while ((incCounter = stream.read(b)) > 0) {
                physicalFileCounter += incCounter;
            }
            AttachmentTest.assertTrue((String)"expecting attachment to be same size as physical file", (physicalFileCounter == attachmentCounter ? 1 : 0) != 0);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public void testReadAsFile() throws IOException {
        File tmp = this.attach.readAsFile("tempxxx.txt");
        FileInputStream stream = null;
        try {
            int incCounter;
            stream = new FileInputStream(tmp);
            int physicalFileCounter = 0;
            byte[] b = new byte[20];
            while ((incCounter = ((InputStream)stream).read(b)) > 0) {
                physicalFileCounter += incCounter;
            }
            AttachmentTest.assertTrue((String)("filelength should be " + FILE_SIZE), (physicalFileCounter == FILE_SIZE ? 1 : 0) != 0);
            ((InputStream)stream).close();
            boolean check = tmp.delete();
            if (!check) {
                System.out.println("temp file " + tmp.getAbsolutePath() + " could not be deleted.");
            }
        }
        finally {
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
    }

    public void testReadURL() throws IOException {
        try {
            SocketReader socketReader = new SocketReader(9999, ((Object)((Object)this)).getClass().getResource("test.txt"));
            socketReader.start();
            URL url = new URL("http://localhost:9999/test");
            Attachment urlAttachment = new Attachment(url);
            urlAttachment.readAsStream();
            AttachmentTest.assertTrue((String)("must only connect once for several calls to attachment but did connect:" + socketReader.getCount() + " times."), (socketReader.getCount() == 1 ? 1 : 0) != 0);
            socketReader.stop();
        }
        catch (SocketException socketException) {
            Nop.reason((String)"SocketException can happen in mavenbuild....thats ok");
        }
    }

    static class SocketReader
    extends Thread {
        private URL myUrl;
        private int port;
        private int count;

        SocketReader(int port, URL url) {
            this.myUrl = url;
            this.port = port;
            this.count = 0;
        }

        public void run() {
            try {
                ServerSocket serverSocket = new ServerSocket(this.port);
                while (true) {
                    InputStream input = null;
                    InputStream localInput = null;
                    OutputStream output = null;
                    try {
                        try {
                            int len;
                            Socket socket = serverSocket.accept();
                            ++this.count;
                            input = socket.getInputStream();
                            while (input.available() == 0) {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    Nop.reason((String)"nothing to do");
                                }
                            }
                            while (input.available() > 0) {
                                input.read();
                                if (input.available() != 0) continue;
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException interruptedException) {
                                    Nop.reason((String)"ignore");
                                }
                            }
                            output = socket.getOutputStream();
                            localInput = this.myUrl.openStream();
                            byte[] buffer = new byte[100];
                            while ((len = localInput.read(buffer, 0, buffer.length)) != -1) {
                                output.write(buffer, 0, len);
                            }
                        }
                        catch (IOException iOException) {
                            Nop.reason((String)"");
                            if (input != null) {
                                input.close();
                            }
                            if (output != null) {
                                output.close();
                            }
                            if (localInput == null) continue;
                            localInput.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            input.close();
                        }
                        if (output != null) {
                            output.close();
                        }
                        if (localInput != null) {
                            localInput.close();
                        }
                        throw throwable;
                    }
                    if (input != null) {
                        input.close();
                    }
                    if (output != null) {
                        output.close();
                    }
                    if (localInput == null) continue;
                    localInput.close();
                }
            }
            catch (IOException iOException) {
                Nop.reason((String)"serverSocket did not work");
                return;
            }
        }

        public int getCount() {
            return this.count;
        }
    }
}

