/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.extension;

import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.injector.extension.ConfigurableWiredThing;
import org.eclipse.riena.core.injector.extension.ExtensionInjector;
import org.eclipse.riena.core.injector.extension.IWireData;
import org.eclipse.riena.core.injector.extension.IWireable;
import org.eclipse.riena.core.injector.extension.Wireable;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class ExtensionInjectorWithWiringTest
extends RienaTestCase {
    public void testWiring() {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorWithWiringTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorWithWiringTest.class, "plugin_ext_wire.xml");
        ConfigurableWiredThing target = new ConfigurableWiredThing();
        ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).andStart(this.getContext());
        IWireData data = target.getData();
        ExtensionInjectorWithWiringTest.assertNotNull((Object)data);
        Wireable.wired = false;
        ExtensionInjectorWithWiringTest.assertTrue((boolean)data.createObjectTypeWithWire().isWired());
        Wireable.wired = false;
        ExtensionInjectorWithWiringTest.assertFalse((boolean)data.createObjectTypeWithoutWire().isWired());
        Wireable.wired = false;
        IWireable wireable = data.createLazyObjectTypeWithWire();
        ExtensionInjectorWithWiringTest.assertFalse((boolean)Wireable.wired);
        ExtensionInjectorWithWiringTest.assertTrue((boolean)wireable.isWired());
        Wireable.wired = false;
        wireable = data.createLazyObjectTypeWithoutWire();
        ExtensionInjectorWithWiringTest.assertFalse((boolean)Wireable.wired);
        ExtensionInjectorWithWiringTest.assertFalse((boolean)wireable.isWired());
        this.removeExtension("core.test.extpoint.id1");
        this.removeExtensionPoint("core.test.extpoint");
        injector.stop();
    }

    public void testWiringWithSystemPropertySetToFalse() {
        this.printTestName();
        System.setProperty("riena.extensions.donotwire", Boolean.TRUE.toString());
        this.addPluginXml(ExtensionInjectorWithWiringTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorWithWiringTest.class, "plugin_ext_wire.xml");
        ConfigurableWiredThing target = new ConfigurableWiredThing();
        ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").expectingExactly(1).into((Object)target).andStart(this.getContext());
        IWireData data = target.getData();
        ExtensionInjectorWithWiringTest.assertNotNull((Object)data);
        Wireable.wired = false;
        ExtensionInjectorWithWiringTest.assertFalse((boolean)data.createObjectTypeWithWire().isWired());
        Wireable.wired = false;
        ExtensionInjectorWithWiringTest.assertFalse((boolean)data.createObjectTypeWithoutWire().isWired());
        Wireable.wired = false;
        IWireable wireable = data.createLazyObjectTypeWithWire();
        ExtensionInjectorWithWiringTest.assertFalse((boolean)Wireable.wired);
        ExtensionInjectorWithWiringTest.assertFalse((boolean)wireable.isWired());
        Wireable.wired = false;
        wireable = data.createLazyObjectTypeWithoutWire();
        ExtensionInjectorWithWiringTest.assertFalse((boolean)Wireable.wired);
        ExtensionInjectorWithWiringTest.assertFalse((boolean)wireable.isWired());
        this.removeExtension("core.test.extpoint.id1");
        this.removeExtensionPoint("core.test.extpoint");
        injector.stop();
        System.clearProperty("riena.extensions.donotwire");
    }
}

