/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.ui.swt.utils.IImagePathExtension;
import org.eclipse.riena.ui.swt.utils.ImageFileExtension;
import org.eclipse.riena.ui.swt.utils.ImageState;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

@UITestCase
public class ImageStoreTest
extends RienaTestCase {
    public void testGetFullName() {
        ImageStore store = ImageStore.getInstance();
        String fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullName", (Object[])new Object[]{"abc", ImageState.HOVER, ImageFileExtension.JPG});
        ImageStoreTest.assertEquals((String)"abc_h_.jpg", (String)fullName);
        fullName = (String)ReflectionUtils.invokeHidden((Object)store, (String)"getFullName", (Object[])new Object[]{"abc", ImageState.NORMAL, ImageFileExtension.GIF});
        ImageStoreTest.assertEquals((String)"abc.gif", (String)fullName);
    }

    public void testGetImage() {
        Shell shell = new Shell();
        ImageStore store = ImageStore.getInstance();
        store.update(new IImagePathExtension[0]);
        Image image = store.getImage("spirit");
        ImageStoreTest.assertNull((Object)image);
        IImagePathExtension extension = new IImagePathExtension(){

            public Bundle getContributingBundle() {
                return Activator.getDefault().getBundle();
            }

            public String getPath() {
                return "icons";
            }
        };
        store.update(new IImagePathExtension[]{extension});
        image = store.getImage("spirit");
        ImageStoreTest.assertNotNull((Object)image);
        SwtUtilities.disposeWidget((Widget)shell);
    }

    public void testGetImageImageFileExtension() {
        Shell shell = new Shell();
        ImageStore store = ImageStore.getInstance();
        IImagePathExtension extension = new IImagePathExtension(){

            public Bundle getContributingBundle() {
                return Activator.getDefault().getBundle();
            }

            public String getPath() {
                return "icons";
            }
        };
        store.update(new IImagePathExtension[]{extension});
        Image image = store.getImage("spirit", ImageFileExtension.PNG);
        ImageStoreTest.assertNotNull((Object)image);
        image = store.getImage("spirit", ImageFileExtension.GIF);
        ImageStoreTest.assertNull((Object)image);
        image = store.getImage("spirit", ImageFileExtension.JPG);
        ImageStoreTest.assertNull((Object)image);
        image = store.getImage("eclipse", ImageFileExtension.PNG);
        ImageStoreTest.assertNull((Object)image);
        image = store.getImage("eclipse", ImageFileExtension.GIF);
        ImageStoreTest.assertNotNull((Object)image);
        image = store.getImage("eclipse", ImageFileExtension.JPG);
        ImageStoreTest.assertNull((Object)image);
        SwtUtilities.disposeWidget((Widget)shell);
    }

    public void testGetImageImageState() {
        Shell shell = new Shell();
        ImageStore store = ImageStore.getInstance();
        IImagePathExtension extension = new IImagePathExtension(){

            public Bundle getContributingBundle() {
                return Activator.getDefault().getBundle();
            }

            public String getPath() {
                return "icons";
            }
        };
        store.update(new IImagePathExtension[]{extension});
        Image image = store.getImage("spirit", ImageState.NORMAL);
        ImageStoreTest.assertNotNull((Object)image);
        image = store.getImage("spirit", ImageState.HOVER);
        ImageStoreTest.assertNotNull((Object)image);
        image = store.getImage("spirit", ImageState.HOVER_HAS_FOCUS);
        ImageStoreTest.assertNull((Object)image);
        SwtUtilities.disposeWidget((Widget)shell);
    }
}

