/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;

public final class ApplicationNodeManager {
    private static Map<String, IApplicationNode> nodeMap = new HashMap<String, IApplicationNode>();
    private static INavigationProcessor defaultNavigationProcessor;
    private static final String DEFAULT_NODE_NAME = "default";

    private ApplicationNodeManager() {
    }

    public static IApplicationNode getApplicationNode() {
        IApplicationNode model = ApplicationNodeManager.getApplicationNode(DEFAULT_NODE_NAME);
        if (model == null && nodeMap.size() == 1) {
            return nodeMap.values().iterator().next();
        }
        return model;
    }

    public static IApplicationNode getApplicationNode(String name) {
        String modelName = name;
        if (modelName == null) {
            modelName = DEFAULT_NODE_NAME;
        }
        return nodeMap.get(modelName);
    }

    public static synchronized void clear() {
        nodeMap = new HashMap<String, IApplicationNode>();
    }

    public static synchronized void registerApplicationNode(IApplicationNode node) {
        String nodeName = node.getLabel();
        if (nodeName == null) {
            nodeName = DEFAULT_NODE_NAME;
        }
        if (nodeMap.containsKey(nodeName)) {
            throw new ApplicationModelFailure("ApplicationNode '" + nodeName + "' already registered");
        }
        nodeMap.put(nodeName, node);
    }

    public static INavigationProcessor getDefaultNavigationProcessor() {
        if (defaultNavigationProcessor == null) {
            defaultNavigationProcessor = new NavigationProcessor();
        }
        return defaultNavigationProcessor;
    }

    public static ISubApplicationNode locateActiveSubApplicationNode() {
        ApplicationNode applicationNode = (ApplicationNode)ApplicationNodeManager.getApplicationNode();
        if (applicationNode == null) {
            return null;
        }
        for (ISubApplicationNode child : applicationNode.getChildren()) {
            if (!child.isActivated()) continue;
            return child;
        }
        return null;
    }

    public static IModuleGroupNode locateActiveModuleGroupNode() {
        ISubApplicationNode subApplicationNode = ApplicationNodeManager.locateActiveSubApplicationNode();
        if (subApplicationNode == null) {
            return null;
        }
        for (IModuleGroupNode child : subApplicationNode.getChildren()) {
            if (!child.isActivated()) continue;
            return child;
        }
        return null;
    }

    public static IModuleNode locateActiveModuleNode() {
        IModuleGroupNode moduleGroupNode = ApplicationNodeManager.locateActiveModuleGroupNode();
        if (moduleGroupNode == null) {
            return null;
        }
        for (IModuleNode child : moduleGroupNode.getChildren()) {
            if (!child.isActivated()) continue;
            return child;
        }
        return null;
    }

    public static ISubModuleNode locateActiveSubModuleNode() {
        IModuleNode moduleNode = ApplicationNodeManager.locateActiveModuleNode();
        if (moduleNode == null) {
            return null;
        }
        for (ISubModuleNode child : moduleNode.getChildren()) {
            ISubModuleNode subModuleNode = ApplicationNodeManager.getActiveSubModule(child);
            if (subModuleNode == null) continue;
            return ApplicationNodeManager.getActiveSubModule(child);
        }
        return null;
    }

    private static ISubModuleNode getActiveSubModule(ISubModuleNode node) {
        if (node.isActivated()) {
            return node;
        }
        for (ISubModuleNode child : node.getChildren()) {
            ISubModuleNode subModuleNode = ApplicationNodeManager.getActiveSubModule(child);
            if (subModuleNode == null) continue;
            return ApplicationNodeManager.getActiveSubModule(child);
        }
        return null;
    }
}

