/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.riena.core.exception.Failure;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.BundleUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LnfManager {
    public static final String RIENA_LNF_SYSTEM_PROPERTY = "riena.lnf";
    private static RienaDefaultLnf defaultLnf = new RienaDefaultLnf();
    private static String currentLnfClassName;
    private static RienaDefaultLnf currentLnf;
    private static final String BUNDLE_CLASS_NAME_SEPARATOR = ":";

    private LnfManager() {
    }

    public static void setDefaultLnf(RienaDefaultLnf defaultLnf) {
        Assert.isNotNull((Object)defaultLnf, (String)"defaultLnf must not be null.");
        LnfManager.defaultLnf = defaultLnf;
        LnfManager.setLnf(null);
    }

    public static void setLnf(String currentLnfClassName) {
        currentLnf = null;
        LnfManager.currentLnfClassName = currentLnfClassName;
    }

    public static void setLnf(RienaDefaultLnf currentLnf) {
        LnfManager.currentLnf = currentLnf;
        currentLnfClassName = currentLnf == null ? null : currentLnf.getClass().getName();
    }

    public static RienaDefaultLnf getLnf() {
        if (currentLnf == null) {
            String className = currentLnfClassName == null ? System.getProperty(RIENA_LNF_SYSTEM_PROPERTY) : currentLnfClassName;
            LnfManager.setLnf(className != null ? LnfManager.createLnf(className) : defaultLnf);
        }
        currentLnf.initialize();
        return currentLnf;
    }

    public static String getLnfClassName() {
        return LnfManager.getLnf().getClass().getName();
    }

    public static void dispose() {
        if (currentLnf != null) {
            currentLnf.uninitialize();
            currentLnf = null;
        }
    }

    private static RienaDefaultLnf createLnf(String lnfClassName) {
        if (lnfClassName == null) {
            return null;
        }
        Class lnfClass = null;
        if (lnfClassName.contains(BUNDLE_CLASS_NAME_SEPARATOR)) {
            String[] parts = lnfClassName.split(BUNDLE_CLASS_NAME_SEPARATOR);
            String bundleSymbolicName = parts[0];
            String className = parts[1];
            Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
            if (!BundleUtil.isReady(bundle)) {
                throw new LnfManagerFailure("can't load LnfClass '" + className + "' from bundle " + bundleSymbolicName + " because bundle is not ready.");
            }
            try {
                lnfClass = bundle.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new LnfManagerFailure("can't load LnfClass '" + className + "' from bundle " + bundleSymbolicName + ".", e);
            }
        } else {
            lnfClass = LnfManager.loadClass(lnfClassName);
        }
        try {
            return (RienaDefaultLnf)lnfClass.newInstance();
        }
        catch (Exception e) {
            throw new LnfManagerFailure("can't create instance for LnfClass '" + lnfClass.getName() + ".", e);
        }
    }

    private static Class<?> loadClass(String className) {
        try {
            return LnfManager.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Nop.reason((String)"try next");
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (Exception exception) {
                Nop.reason((String)"try next");
                throw new LnfManagerFailure("can't load LnfClass '" + className + ".");
            }
        }
    }

    private static class LnfManagerFailure
    extends Failure {
        public LnfManagerFailure(String msg) {
            super(msg);
        }

        public LnfManagerFailure(String msg, Throwable thrown) {
            super(msg, thrown);
        }
    }
}

