/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.IApplicationNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.ui.swt.component.LogoComposite;
import org.eclipse.riena.navigation.ui.swt.component.SwitcherComposite;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellRenderer;
import org.eclipse.riena.ui.swt.AbstractTitleBarMouseListener;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.AbstractTitleBarRenderer;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TitleComposite
extends Composite {
    private TitlelessShellMouseListener mouseListener;
    private ApplicationNode node;
    private IApplicationNodeListener appNodeListener;

    public TitleComposite(Shell parentShell, ApplicationNode node) {
        super((Composite)parentShell, 0);
        this.node = node;
        this.appNodeListener = new ApplicationLabelListener();
        node.addListener((INavigationNodeListener)this.appNodeListener);
        this.init(parentShell);
    }

    private void init(Shell parentShell) {
        this.setBackgroundMode(2);
        Image image = LnfManager.getLnf().getImage("TitlelessShell.backgroundImage");
        this.setBackgroundImage(image);
        this.setLayout((Layout)new FormLayout());
        ShellBorderRenderer borderRenderer = (ShellBorderRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
        int borderWidth = borderRenderer.getBorderWidth();
        FormData data = new FormData();
        data.top = new FormAttachment((Control)parentShell, borderWidth);
        data.left = new FormAttachment(0, borderWidth);
        data.right = new FormAttachment(100, -borderWidth);
        this.setLayoutData(data);
        new LogoComposite(this, 0);
        new SwitcherComposite(this, this.node);
        this.addListeners();
    }

    private void addListeners() {
        this.addPaintListener(new TitlelessPaintListener());
        this.mouseListener = new TitlelessShellMouseListener();
        this.addMouseListener((MouseListener)this.mouseListener);
        this.addMouseMoveListener((MouseMoveListener)this.mouseListener);
        this.addMouseTrackListener((MouseTrackListener)this.mouseListener);
    }

    private ShellRenderer getShellRenderer() {
        ShellRenderer shellRenderer = (ShellRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.renderer");
        return shellRenderer;
    }

    public void dispose() {
        if (this.mouseListener != null) {
            this.removeMouseListener((MouseListener)this.mouseListener);
            this.removeMouseMoveListener((MouseMoveListener)this.mouseListener);
            this.removeMouseTrackListener((MouseTrackListener)this.mouseListener);
            this.mouseListener.dispose();
            this.mouseListener = null;
        }
        if (this.node != null) {
            this.node.removeListener((INavigationNodeListener)this.appNodeListener);
            this.appNodeListener = null;
        }
        super.dispose();
    }

    private class ApplicationLabelListener
    extends ApplicationNodeListener {
        private ApplicationLabelListener() {
        }

        public void labelChanged(IApplicationNode source) {
            super.labelChanged((INavigationNode)source);
            TitleComposite.this.redraw();
        }
    }

    private class TitlelessPaintListener
    implements PaintListener {
        private TitlelessPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            this.onPaint(e);
        }

        private void onPaint(PaintEvent e) {
            if (e.getSource() instanceof Control) {
                Control shell = (Control)e.getSource();
                ShellRenderer shellRenderer = TitleComposite.this.getShellRenderer();
                Rectangle shellBounds = shell.getBounds();
                Rectangle bounds = new Rectangle(0, 0, shellBounds.width, shellRenderer.getHeight());
                shellRenderer.setBounds(bounds);
                RienaDefaultLnf lnf = LnfManager.getLnf();
                shellRenderer.setCloseable(lnf.getBooleanSetting("TitlelessShell.showClose"));
                shellRenderer.setMaximizable(lnf.getBooleanSetting("TitlelessShell.showMax"));
                shellRenderer.setMinimizable(lnf.getBooleanSetting("TitlelessShell.showMin"));
                shellRenderer.paint(e.gc, shell);
            }
        }
    }

    private class TitlelessShellMouseListener
    extends AbstractTitleBarMouseListener {
        private TitlelessShellMouseListener() {
        }

        protected AbstractTitleBarRenderer getTitleBarRenderer() {
            return TitleComposite.this.getShellRenderer();
        }
    }
}

