/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.metatype.DataParser;
import org.eclipse.equinox.metatype.FragmentUtils;
import org.eclipse.equinox.metatype.Logging;
import org.eclipse.equinox.metatype.MetaTypeMsg;
import org.eclipse.equinox.metatype.ObjectClassDefinitionImpl;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MetaTypeProviderImpl
implements MetaTypeProvider {
    public static final String METADATA_NOT_FOUND = "METADATA_NOT_FOUND";
    public static final String OCD_ID_NOT_FOUND = "OCD_ID_NOT_FOUND";
    public static final String ASK_INVALID_LOCALE = "ASK_INVALID_LOCALE";
    public static final String META_FILE_EXT = ".XML";
    public static final String RESOURCE_FILE_CONN = "_";
    public static final String RESOURCE_FILE_EXT = ".properties";
    public static final char DIRECTORY_SEP = '/';
    Bundle _bundle;
    Hashtable _allPidOCDs = new Hashtable(7);
    Hashtable _allFPidOCDs = new Hashtable(7);
    String[] _locales;
    boolean _isThereMeta = false;

    MetaTypeProviderImpl(Bundle bundle, SAXParserFactory parserFactory) throws IOException {
        this._bundle = bundle;
        this._isThereMeta = this.readMetaFiles(bundle, parserFactory);
        if (!this._isThereMeta) {
            Logging.log(2, NLS.bind((String)MetaTypeMsg.METADATA_NOT_FOUND, (Object)new Long(bundle.getBundleId()), (Object)bundle.getSymbolicName()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean readMetaFiles(Bundle bundle, SAXParserFactory parserFactory) throws IOException {
        isThereMetaHere = false;
        allFileKeys = FragmentUtils.findEntryPaths(bundle, "OSGI-INF/metatype");
        if (allFileKeys != null) ** GOTO lbl36
        return isThereMetaHere;
lbl-1000:
        // 1 sources

        {
            fileName = (String)allFileKeys.nextElement();
            pidToOCD = null;
            urls = FragmentUtils.findEntries(bundle, fileName);
            if (urls == null) continue;
            i = 0;
            while (i < urls.length) {
                try {
                    _isMetaDataFile = true;
                    parser = new DataParser(bundle, urls[i], parserFactory);
                    pidToOCD = parser.doParse();
                    if (pidToOCD == null) {
                        _isMetaDataFile = false;
                    }
                }
                catch (Exception v0) {
                    _isMetaDataFile = false;
                }
                if (_isMetaDataFile && pidToOCD != null) {
                    pids = pidToOCD.keys();
                    while (pids.hasMoreElements()) {
                        pid = (String)pids.nextElement();
                        ocd = (ObjectClassDefinitionImpl)pidToOCD.get(pid);
                        if (ocd.getType() == 0) {
                            isThereMetaHere = true;
                            this._allPidOCDs.put(pid, ocd);
                            continue;
                        }
                        isThereMetaHere = true;
                        this._allFPidOCDs.put(pid, ocd);
                    }
                }
                ++i;
            }
lbl36:
            // 3 sources

            ** while (allFileKeys.hasMoreElements())
        }
lbl37:
        // 1 sources

        return isThereMetaHere;
    }

    public ObjectClassDefinition getObjectClassDefinition(String pid, String locale) {
        if (this.isInvalidLocale(locale)) {
            throw new IllegalArgumentException(NLS.bind((String)MetaTypeMsg.ASK_INVALID_LOCALE, (Object)pid, (Object)locale));
        }
        if (this._allPidOCDs.containsKey(pid)) {
            ObjectClassDefinitionImpl ocd = (ObjectClassDefinitionImpl)((ObjectClassDefinitionImpl)this._allPidOCDs.get(pid)).clone();
            ocd.setResourceBundle(locale, this._bundle);
            return ocd;
        }
        if (this._allFPidOCDs.containsKey(pid)) {
            ObjectClassDefinitionImpl ocd = (ObjectClassDefinitionImpl)((ObjectClassDefinitionImpl)this._allFPidOCDs.get(pid)).clone();
            ocd.setResourceBundle(locale, this._bundle);
            return ocd;
        }
        throw new IllegalArgumentException(NLS.bind((String)MetaTypeMsg.OCD_ID_NOT_FOUND, (Object)pid));
    }

    public boolean isInvalidLocale(String locale) {
        if (locale == null || locale.length() == 0) {
            return false;
        }
        int idx_first = locale.indexOf(95);
        int idx_second = locale.lastIndexOf(95);
        if (idx_first == -1 && locale.length() == 2) {
            return false;
        }
        return idx_first != 2 || idx_second != 5 && idx_second != 2;
    }

    public synchronized String[] getLocales() {
        ObjectClassDefinitionImpl ocd;
        if (this._locales != null) {
            return this.checkForDefault(this._locales);
        }
        Vector<String> localizationFiles = new Vector<String>(7);
        Enumeration ocds = this._allPidOCDs.elements();
        while (ocds.hasMoreElements()) {
            ocd = (ObjectClassDefinitionImpl)ocds.nextElement();
            if (ocd._localization == null || localizationFiles.contains(ocd._localization)) continue;
            localizationFiles.add(ocd._localization);
        }
        ocds = this._allFPidOCDs.elements();
        while (ocds.hasMoreElements()) {
            ocd = (ObjectClassDefinitionImpl)ocds.nextElement();
            if (ocd._localization == null || localizationFiles.contains(ocd._localization)) continue;
            localizationFiles.add(ocd._localization);
        }
        if (localizationFiles.size() == 0) {
            localizationFiles.add("OSGI-INF/l10n/bundle");
        }
        Vector<String> locales = new Vector<String>(7);
        Enumeration eLocalizationFiles = localizationFiles.elements();
        while (eLocalizationFiles.hasMoreElements()) {
            String localizationFile = (String)eLocalizationFiles.nextElement();
            int iSlash = localizationFile.lastIndexOf(47);
            String baseDir = iSlash < 0 ? "" : localizationFile.substring(0, iSlash);
            String baseFileName = String.valueOf(localizationFile) + RESOURCE_FILE_CONN;
            Enumeration resources = FragmentUtils.findEntryPaths(this._bundle, baseDir);
            if (resources == null) continue;
            while (resources.hasMoreElements()) {
                String resource = (String)resources.nextElement();
                if (!resource.startsWith(baseFileName) || !resource.toLowerCase().endsWith(RESOURCE_FILE_EXT)) continue;
                locales.add(resource.substring(baseFileName.length(), resource.length() - RESOURCE_FILE_EXT.length()));
            }
        }
        this._locales = locales.toArray(new String[locales.size()]);
        return this.checkForDefault(this._locales);
    }

    private String[] checkForDefault(String[] locales) {
        if (locales == null || locales.length == 0 || locales.length == 1 && Locale.getDefault().toString().equals(locales[0])) {
            return null;
        }
        return locales;
    }
}

