/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.dialogs.AddProfileDialog;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ValidationDialogServiceUI;
import org.eclipse.equinox.internal.provisional.p2.ui.model.Profiles;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.ColocatedRepositoryManipulator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IProfileChooser;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IUViewQueryContext;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.PlanValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryManipulator;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ProvAdminUIActivator
extends AbstractUIPlugin {
    private static ProvAdminUIActivator plugin;
    private static BundleContext context;
    public static final String PLUGIN_ID = "org.eclipse.equinox.internal.provisional.p2.ui.admin";
    public static final String PERSPECTIVE_ID = "org.eclipse.equinox.internal.provisional.p2.ui.admin.ProvisioningPerspective";
    private ServiceRegistration certificateUIRegistration;
    private IPropertyChangeListener preferenceListener;
    Policy policy;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static BundleContext getContext() {
        return context;
    }

    public static ProvAdminUIActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ProvAdminUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        this.initializePolicy();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.IServiceUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.certificateUIRegistration = context.registerService(clazz.getName(), (Object)new ValidationDialogServiceUI(), null);
        this.getPreferenceStore().addPropertyChangeListener(this.getPreferenceListener());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        this.certificateUIRegistration.unregister();
        this.getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        super.stop(bundleContext);
        this.policy = null;
    }

    private IPropertyChangeListener getPreferenceListener() {
        if (this.preferenceListener == null) {
            this.preferenceListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ProvAdminUIActivator.this.updateForPreferences(ProvAdminUIActivator.this.getPolicy().getQueryContext());
                }
            };
        }
        return this.preferenceListener;
    }

    void updateForPreferences(IUViewQueryContext queryContext) {
        if (this.getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.showGroupsOnly")) {
            queryContext.setVisibleAvailableIUProperty("org.eclipse.equinox.p2.type.group");
        } else {
            queryContext.setVisibleAvailableIUProperty(null);
        }
        if (this.getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.showInstallRoots")) {
            queryContext.setVisibleInstalledIUProperty("org.eclipse.equinox.p2.type.root");
        } else {
            queryContext.setVisibleInstalledIUProperty(null);
        }
        if (this.getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.hideSystemRepos")) {
            queryContext.setArtifactRepositoryFlags(2);
            queryContext.setMetadataRepositoryFlags(2);
        } else {
            queryContext.setArtifactRepositoryFlags(0);
            queryContext.setMetadataRepositoryFlags(0);
        }
        queryContext.setShowLatestVersionsOnly(this.getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.collapseIUVersions"));
        queryContext.setUseCategories(this.getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.useCategories"));
    }

    void initializePolicy() {
        this.policy = new Policy();
        IUViewQueryContext queryContext = new IUViewQueryContext(2);
        this.policy.setQueryContext(queryContext);
        this.updateForPreferences(queryContext);
        this.policy.setPlanValidator(new PlanValidator(){

            public boolean continueWorkingWithPlan(ProvisioningPlan plan, Shell shell) {
                return plan != null;
            }
        });
        this.policy.setProfileChooser(new IProfileChooser(){

            public String getProfileId(Shell shell) {
                ProvElementContentProvider provider = new ProvElementContentProvider();
                if (provider.getElements((Object)new Profiles(ProvAdminUIActivator.this.getPolicy())).length == 0) {
                    AddProfileDialog dialog = new AddProfileDialog(shell, new String[0]);
                    if (dialog.open() == 0) {
                        return dialog.getAddedProfileId();
                    }
                    return null;
                }
                ListDialog dialog = new ListDialog(shell);
                dialog.setTitle(ProvAdminUIMessages.MetadataRepositoriesView_ChooseProfileDialogTitle);
                dialog.setLabelProvider((ILabelProvider)new ProvElementLabelProvider());
                dialog.setInput((Object)new Profiles(ProvAdminUIActivator.this.getPolicy()));
                dialog.setContentProvider((IStructuredContentProvider)provider);
                dialog.open();
                Object[] result = dialog.getResult();
                if (result != null && result.length > 0) {
                    IProfile profile;
                    Object object = result[0];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfile");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((profile = (IProfile)ProvUI.getAdapter((Object)object, (Class)clazz)) != null) {
                        return profile.getProfileId();
                    }
                }
                return null;
            }
        });
        this.policy.setRepositoryManipulator((RepositoryManipulator)new ColocatedRepositoryManipulator(this.policy, null));
    }

    public Policy getPolicy() {
        return this.policy;
    }
}

