/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.ProvView;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.RemoveRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.RepositoryContentProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;

abstract class RepositoriesView
extends ProvView {
    private Action addRepositoryAction;
    private Action removeRepositoryAction;
    private PropertyDialogAction propertiesAction;
    private StructuredViewerProvisioningListener listener;
    static /* synthetic */ Class class$0;

    protected void addListeners() {
        super.addListeners();
        this.listener = new StructuredViewerProvisioningListener((StructuredViewer)this.viewer, this.getListenerEventTypes()){

            protected void refreshViewer() {
                RepositoriesView.this.refreshAll(false);
            }
        };
        ProvUI.addProvisioningListener((ProvUIProvisioningListener)this.listener);
    }

    protected void removeListeners() {
        super.removeListeners();
        ProvUI.removeProvisioningListener((ProvUIProvisioningListener)this.listener);
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        manager.add((IAction)this.removeRepositoryAction);
        manager.add((IAction)this.propertiesAction);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        if (this.removeRepositoryAction.isEnabled()) {
            manager.add((IAction)this.removeRepositoryAction);
        }
        if (this.propertiesAction.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.propertiesAction);
        }
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        manager.add((IAction)this.removeRepositoryAction);
    }

    protected void makeActions() {
        super.makeActions();
        this.addRepositoryAction = new AddRepositoryAction();
        this.removeRepositoryAction = new RemoveRepositoryAction();
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeRepositoryAction);
        this.propertiesAction = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        IStructuredSelection selection = this.getSelection();
        if (selection.size() == 1 && this.isRepository(selection.getFirstElement())) {
            this.propertiesAction.setEnabled(true);
            this.removeRepositoryAction.setEnabled(true);
        } else {
            this.propertiesAction.setEnabled(false);
            this.removeRepositoryAction.setEnabled(false);
        }
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                RepositoriesView.this.selectionChanged(ss);
            }
        });
    }

    protected IAction getDoubleClickAction() {
        return this.propertiesAction;
    }

    /*
     * Unable to fully structure code
     */
    protected void selectionChanged(IStructuredSelection selection) {
        if (selection.size() != 1) ** GOTO lbl-1000
        v0 = selection.getFirstElement();
        v1 = RepositoriesView.class$0;
        if (v1 == null) {
            try {
                v1 = RepositoriesView.class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException v2) {
                throw new NoClassDefFoundError(v2.getMessage());
            }
        }
        if (ProvUI.getAdapter((Object)v0, (Class)v1) != null || this.isRepository(selection.getFirstElement())) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        this.propertiesAction.setEnabled(v3);
        enabled = false;
        selectionArray = selection.toArray();
        i = 0;
        while (i < selectionArray.length) {
            if (!this.isRepository(selectionArray[i])) {
                enabled = false;
                break;
            }
            enabled = true;
            ++i;
        }
        this.removeRepositoryAction.setEnabled(enabled);
    }

    protected IContentProvider getContentProvider() {
        return new RepositoryContentProvider();
    }

    protected abstract int openAddRepositoryDialog(Shell var1);

    protected abstract RemoveRepositoryOperation getRemoveOperation(Object[] var1);

    protected abstract String getAddCommandLabel();

    protected abstract String getAddCommandTooltip();

    protected String getRemoveCommandLabel() {
        return ProvAdminUIMessages.RepositoriesView_RemoveCommandLabel;
    }

    protected abstract String getRemoveCommandTooltip();

    protected boolean isRepository(Object element) {
        return element instanceof IRepositoryElement;
    }

    protected abstract int getListenerEventTypes();

    protected List getVisualProperties() {
        List list = super.getVisualProperties();
        list.add("org.eclipse.equinox.internal.provisional.p2.ui.admin.hideSystemRepos");
        return list;
    }

    private class AddRepositoryAction
    extends Action {
        AddRepositoryAction() {
            this.setText(RepositoriesView.this.getAddCommandLabel());
            this.setToolTipText(RepositoriesView.this.getAddCommandTooltip());
            this.setImageDescriptor(ProvUIImages.getImageDescriptor((String)"obj/artifact_repo_obj.gif"));
        }

        public void run() {
            Object[] elements = ((ITreeContentProvider)RepositoriesView.this.viewer.getContentProvider()).getElements(RepositoriesView.this.getInput());
            ArrayList<URI> urls = new ArrayList<URI>();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IRepositoryElement) {
                    urls.add(((IRepositoryElement)elements[i]).getLocation());
                }
                ++i;
            }
            RepositoriesView.this.openAddRepositoryDialog(RepositoriesView.this.getShell());
        }
    }

    private class RemoveRepositoryAction
    extends Action {
        RemoveRepositoryAction() {
            this.setText(RepositoriesView.this.getRemoveCommandLabel());
            this.setToolTipText(RepositoriesView.this.getRemoveCommandTooltip());
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        }

        public void run() {
            ProvisioningOperationRunner.run((ProvisioningOperation)RepositoriesView.this.getRemoveOperation(RepositoriesView.this.getSelection().toArray()), (int)3);
        }
    }
}

