/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.EventHandler;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractItemProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionObserver;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.menus.CommandContributionItem;

public abstract class AbstractItemRidget
extends AbstractSWTWidgetRidget
implements IActionRidget {
    private static final String EMPTY_STRING = "";
    private Item item;
    private String text;
    private String icon;
    private ActionObserver actionObserver = new ActionObserver((IRidget)this);
    private boolean textAlreadyInitialized = false;
    private boolean useRidgetIcon = false;
    private AbstractItemProperties itemProperties;
    private String itemId;

    abstract AbstractItemProperties createProperties();

    protected void bindUIControl() {
        Item control = this.getUIControl();
        if (control != null) {
            this.item = control;
            this.itemId = super.getID();
            this.initText();
            this.updateUIText();
            this.updateUIIcon();
            this.setItemProperties(this.createProperties());
        }
    }

    public final String getID() {
        String idString = super.getID();
        if (StringUtils.isEmpty((CharSequence)idString)) {
            idString = this.itemId;
        }
        return idString;
    }

    private void initText() {
        if (this.text == null && !this.textAlreadyInitialized && this.getUIControl() != null && !this.getUIControl().isDisposed()) {
            this.text = this.getUIControl().getText();
            if (this.text == null) {
                this.text = EMPTY_STRING;
            }
            this.textAlreadyInitialized = true;
        }
    }

    protected void unbindUIControl() {
        this.item = null;
    }

    public Item getUIControl() {
        return (Item)super.getUIControl();
    }

    public final void addListener(IActionListener listener) {
        this.getActionObserver().addListener(listener);
    }

    public final void addListener(Object target, String action) {
        this.addListener(EventHandler.create(IActionListener.class, target, action));
    }

    public final void removeListener(IActionListener listener) {
        this.getActionObserver().removeListener(listener);
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public String getIcon() {
        return this.icon;
    }

    public final String getText() {
        return this.text;
    }

    public void setIcon(String icon) {
        boolean oldUseRidgetIcon = this.useRidgetIcon;
        this.useRidgetIcon = true;
        String oldIcon = this.icon;
        this.icon = icon;
        if (this.hasChanged(oldIcon, icon) || !oldUseRidgetIcon) {
            this.updateUIIcon();
        }
    }

    public final void setText(String newText) {
        String oldText = this.text;
        this.text = newText;
        this.updateUIText();
        this.firePropertyChange("text", oldText, this.text);
    }

    protected CommandContributionItem getContributionItem() {
        Item uiItem = this.getUIControl();
        if (uiItem == null || uiItem.isDisposed()) {
            return null;
        }
        if (uiItem.getData() instanceof CommandContributionItem) {
            return (CommandContributionItem)uiItem.getData();
        }
        return null;
    }

    public boolean isVisible() {
        if (!this.getMarkersOfType(HiddenMarker.class).isEmpty()) {
            return false;
        }
        if (this.getUIControl() != null) {
            return !this.getUIControl().isDisposed();
        }
        return this.savedVisibleState;
    }

    public boolean isEnabled() {
        boolean enabled = super.isEnabled();
        CommandContributionItem commandItem = this.getContributionItem();
        if (commandItem != null) {
            enabled = enabled && commandItem.isEnabled();
        }
        return enabled;
    }

    private void updateUIText() {
        if (this.item != null) {
            this.item.setText(this.text);
        }
    }

    protected boolean updateUIIcon() {
        Item control = this.getUIControl();
        if (control != null) {
            Image image = null;
            if (this.getIcon() != null) {
                image = this.getManagedImage(this.getIcon());
            }
            if (image != null || this.useRidgetIcon) {
                control.setImage(image);
                return true;
            }
        }
        return false;
    }

    protected void updateToolTip() {
    }

    protected ActionObserver getActionObserver() {
        return this.actionObserver;
    }

    private void setItemProperties(AbstractItemProperties itemProperties) {
        this.itemProperties = itemProperties;
    }

    AbstractItemProperties getItemProperties() {
        return this.itemProperties;
    }

    void createItem() {
        Item uiItem = this.getUIControl();
        if (uiItem == null || uiItem.isDisposed()) {
            this.getItemProperties().createItem();
        }
    }
}

