/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.DisabledMarkerVisualizer;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;

public class BasicMarkerSupport
extends AbstractMarkerSupport {
    private static boolean alwaysSkipRedraw = false;
    private static boolean osChecked = false;
    private DisabledMarkerVisualizer disabledMarkerVisualizer;

    public BasicMarkerSupport(IBasicMarkableRidget ridget, PropertyChangeSupport propertyChangeSupport) {
        super(ridget, propertyChangeSupport);
        if (!osChecked) {
            osChecked = true;
            String osname = System.getProperty("org.osgi.framework.os.name");
            if (osname != null && osname.equalsIgnoreCase("macosx")) {
                alwaysSkipRedraw = true;
            }
        }
        this.createDisabledMarkerVisualizer();
    }

    private void createDisabledMarkerVisualizer() {
        this.disabledMarkerVisualizer = new DisabledMarkerVisualizer((IRidget)this.getRidget());
    }

    protected DisabledMarkerVisualizer getDisabledMarkerVisualizer() {
        return this.disabledMarkerVisualizer;
    }

    public void updateMarkers() {
        this.updateUIControl();
    }

    protected void handleMarkerAttributesChanged() {
        this.updateUIControl();
        super.handleMarkerAttributesChanged();
    }

    private void updateUIControl() {
        Control control = (Control)this.getUIControl();
        if (control != null) {
            this.stopRedraw(control);
            try {
                this.updateUIControl(control);
            }
            finally {
                this.startRedraw(control);
            }
        }
    }

    protected void updateUIControl(Control control) {
        this.updateVisible(control);
        this.updateDisabled(control);
    }

    protected void updateVisible(Control control) {
        control.setVisible(!this.hasHiddenMarkers());
    }

    protected void updateDisabled(Control control) {
        boolean on = LnfManager.getLnf().getBooleanSetting("DisabledMarker.advanced");
        if (on) {
            this.getDisabledMarkerVisualizer().updateDisabled();
        } else {
            control.setEnabled(this.getRidget().isEnabled());
        }
    }

    private void startRedraw(Control control) {
        if (!this.skipRedrawForBug258176(control)) {
            control.setRedraw(true);
        }
        control.redraw();
    }

    private void stopRedraw(Control control) {
        if (!this.skipRedrawForBug258176(control)) {
            control.setRedraw(false);
        }
    }

    private boolean skipRedrawForBug258176(Control control) {
        if (alwaysSkipRedraw) {
            return true;
        }
        return control instanceof Combo || control instanceof Table || control instanceof List;
    }
}

