/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public final class ColumnUtils {
    public static void applyColumnWidths(Table control, ColumnLayoutData[] columnWidths) {
        ColumnUtils.applyColumnWidths((Composite)control, columnWidths, control.getColumnCount());
    }

    public static void applyColumnWidths(Tree control, ColumnLayoutData[] columnWidths) {
        ColumnUtils.applyColumnWidths((Composite)control, columnWidths, control.getColumnCount());
    }

    public static ColumnLayoutData[] copyWidths(Object[] source) {
        ColumnLayoutData[] result = null;
        if (source != null) {
            result = new ColumnLayoutData[source.length];
            int i = 0;
            while (i < source.length) {
                ColumnPixelData data;
                if (source[i] instanceof ColumnPixelData) {
                    data = (ColumnPixelData)source[i];
                    result[i] = new ColumnPixelData(data.width, data.resizable, data.addTrim);
                } else if (source[i] instanceof ColumnWeightData) {
                    data = (ColumnWeightData)source[i];
                    result[i] = new ColumnWeightData(data.weight, data.minimumWidth, data.resizable);
                } else {
                    String msg = String.format("Unsupported type in column #%d: %s", i, source[i]);
                    throw new IllegalArgumentException(msg);
                }
                ++i;
            }
        }
        return result;
    }

    private static void applyColumnWidths(Composite control, ColumnLayoutData[] columnWidths, int expectedCols) {
        ColumnLayoutData[] columnData;
        if (columnWidths == null || columnWidths.length != expectedCols) {
            columnData = new ColumnLayoutData[expectedCols];
            int i = 0;
            while (i < expectedCols) {
                columnData[i] = new ColumnWeightData(1, true);
                ++i;
            }
        } else {
            columnData = columnWidths;
        }
        Composite parent = control.getParent();
        if (control.getLayout() instanceof TableLayout) {
            TableLayout layout = new TableLayout();
            int index = 0;
            while (index < expectedCols) {
                layout.addColumnData(columnData[index]);
                ++index;
            }
            control.setLayout((Layout)layout);
            if (parent.isVisible()) {
                parent.layout(true, true);
            }
        } else if (control instanceof Tree && control.getLayout() == null && parent.getLayout() == null && parent.getChildren().length == 1 || parent.getLayout() instanceof TreeColumnLayout) {
            TreeColumnLayout layout = new TreeColumnLayout();
            int index = 0;
            while (index < expectedCols) {
                Widget column = ColumnUtils.getColumn((Control)control, index);
                layout.setColumnData(column, columnData[index]);
                ++index;
            }
            parent.setLayout((Layout)layout);
            if (parent.isVisible()) {
                parent.layout();
            }
        } else if (control instanceof Table && control.getLayout() == null && parent.getLayout() == null && parent.getChildren().length == 1 || parent.getLayout() instanceof TableColumnLayout) {
            TableColumnLayout layout = new TableColumnLayout();
            int index = 0;
            while (index < expectedCols) {
                Widget column = ColumnUtils.getColumn((Control)control, index);
                layout.setColumnData(column, columnData[index]);
                ++index;
            }
            parent.setLayout((Layout)layout);
            if (parent.isVisible()) {
                parent.layout();
            }
        } else {
            int width;
            int widthRemaining = control.getClientArea().width;
            int totalWeights = 0;
            int index = 0;
            while (index < expectedCols) {
                ColumnLayoutData data = columnData[index];
                if (data instanceof ColumnPixelData) {
                    ColumnPixelData pixelData = (ColumnPixelData)data;
                    width = pixelData.width;
                    if (pixelData.addTrim) {
                        width += ColumnUtils.getColumnTrim();
                    }
                    ColumnUtils.configureColumn((Control)control, index, width, data.resizable);
                    widthRemaining -= width;
                } else if (data instanceof ColumnWeightData) {
                    totalWeights += ((ColumnWeightData)data).weight;
                }
                ++index;
            }
            int slice = totalWeights > 0 ? Math.max(0, widthRemaining / totalWeights) : 0;
            int index2 = 0;
            while (index2 < expectedCols) {
                if (columnData[index2] instanceof ColumnWeightData) {
                    ColumnWeightData data = (ColumnWeightData)columnData[index2];
                    width = Math.max(data.minimumWidth, data.weight * slice);
                    ColumnUtils.configureColumn((Control)control, index2, width, data.resizable);
                }
                ++index2;
            }
        }
    }

    private static void configureColumn(Control control, int index, int width, boolean resizable) {
        Widget column = ColumnUtils.getColumn(control, index);
        if (column instanceof TreeColumn) {
            ((TreeColumn)column).setWidth(width);
            ((TreeColumn)column).setResizable(resizable);
        } else if (column instanceof TableColumn) {
            ((TableColumn)column).setWidth(width);
            ((TableColumn)column).setResizable(resizable);
        }
    }

    private static Widget getColumn(Control control, int index) {
        if (control instanceof Table) {
            return ((Table)control).getColumn(index);
        }
        if (control instanceof Tree) {
            return ((Tree)control).getColumn(index);
        }
        throw new IllegalArgumentException("unsupported type: " + control);
    }

    private static int getColumnTrim() {
        int result = 3;
        if (Util.isWindows()) {
            result = 4;
        } else if (Util.isMac()) {
            result = 24;
        }
        return result;
    }

    private ColumnUtils() {
    }
}

