/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.ui.ridgets.IListRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DisabledMarkerVisualizer {
    private IRidget ridget;
    private final DisabledPainter disabledRepresenterPainter = new DisabledPainter();
    private final RenderMemento renderMemento = new RenderMemento();

    public DisabledMarkerVisualizer(IRidget ridget) {
        this.ridget = ridget;
    }

    private IRidget getRidget() {
        return this.ridget;
    }

    private Control getControl() {
        return (Control)this.getRidget().getUIControl();
    }

    public void updateDisabled() {
        Control control = this.getControl();
        control.setEnabled(this.getRidget().isEnabled());
        this.removePaintlistener(control);
        if (!this.getRidget().isEnabled()) {
            this.storeHeaderVisiblity();
            this.updateComplexControl(false);
            this.addPaintlistener(control);
        } else {
            this.updateComplexControl(this.renderMemento.headerVisible);
        }
        control.redraw();
    }

    protected void removePaintlistener(Control control) {
        if (ChoiceComposite.class.isAssignableFrom(control.getClass())) {
            ChoiceComposite choice = (ChoiceComposite)ChoiceComposite.class.cast(control);
            Control[] controlArray = choice.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.removePaintlistener(child);
                ++n2;
            }
        } else {
            control.removePaintListener((PaintListener)this.disabledRepresenterPainter);
        }
    }

    protected void addPaintlistener(Control control) {
        if (ChoiceComposite.class.isAssignableFrom(control.getClass())) {
            ChoiceComposite choice = (ChoiceComposite)ChoiceComposite.class.cast(control);
            Control[] controlArray = choice.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.addPaintlistener(child);
                ++n2;
            }
        } else {
            control.addPaintListener((PaintListener)this.disabledRepresenterPainter);
        }
    }

    private void storeHeaderVisiblity() {
        if (this.getControl() instanceof Tree) {
            Tree tree = (Tree)this.getControl();
            this.renderMemento.headerVisible = tree.getHeaderVisible();
        } else if (this.getControl() instanceof Table) {
            Table table = (Table)this.getControl();
            this.renderMemento.headerVisible = table.getHeaderVisible();
        }
    }

    private void updateComplexControl(boolean headerVisible) {
        if (this.getControl() instanceof Tree) {
            Tree tree = (Tree)this.getControl();
            tree.setHeaderVisible(headerVisible);
            if (!this.getRidget().isEnabled()) {
                tree.removeAll();
            } else {
                ITreeRidget treeRidget = (ITreeRidget)this.getRidget();
                treeRidget.updateFromModel();
            }
        } else if (this.getControl() instanceof Table) {
            Table table = (Table)this.getControl();
            table.setHeaderVisible(headerVisible);
            if (!this.getRidget().isEnabled()) {
                table.removeAll();
            } else {
                ITableRidget tableRidget = (ITableRidget)this.getRidget();
                tableRidget.updateFromModel();
            }
        } else if (this.getControl() instanceof List) {
            List list = (List)this.getControl();
            if (!this.getRidget().isEnabled()) {
                list.removeAll();
            } else {
                IListRidget tableRidget = (IListRidget)this.getRidget();
                tableRidget.updateFromModel();
            }
        }
    }

    private class DisabledPainter
    implements PaintListener {
        private DisabledPainter() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            int alpha = LnfManager.getLnf().getIntegerSetting("DisabledMarker.standardAlpha");
            Widget widget = e.widget;
            if (widget instanceof Table || widget instanceof Tree || widget instanceof List || widget instanceof Combo || widget instanceof DateTime) {
                alpha = LnfManager.getLnf().getIntegerSetting("DisabledMarker.complexAlpha");
            }
            gc.setAlpha(alpha);
            Color color = LnfManager.getLnf().getColor("DisabledMarker.backgroundColor");
            gc.setBackground(color);
            gc.fillRectangle(0, 0, ((DisabledMarkerVisualizer)DisabledMarkerVisualizer.this).getControl().getBounds().width, ((DisabledMarkerVisualizer)DisabledMarkerVisualizer.this).getControl().getBounds().height);
        }
    }

    private static class RenderMemento {
        boolean headerVisible = true;

        private RenderMemento() {
        }
    }
}

