/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

public class NavigationNodeId {
    private String instanceId;
    private String typeId;
    private int hash = 0;

    public NavigationNodeId(String typeId, String instanceId) {
        if (!this.checkId(typeId)) {
            throw new IllegalArgumentException("ID with illegal characters: " + typeId);
        }
        this.typeId = typeId;
        this.instanceId = instanceId;
    }

    public NavigationNodeId(String typeId) {
        this(typeId, null);
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean equals(Object other) {
        if (other instanceof NavigationNodeId) {
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            NavigationNodeId otherId = (NavigationNodeId)other;
            return this.equals(this.typeId, otherId.getTypeId()) && this.equals(this.instanceId, otherId.getInstanceId());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NavNodeId:");
        if (this.typeId != null) {
            sb.append(this.typeId);
        } else {
            sb.append("null");
        }
        if (this.instanceId != null) {
            sb.append("[");
            sb.append(this.instanceId);
            sb.append("]");
        } else {
            sb.append("[null]");
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.hash == 0) {
            if (this.typeId != null) {
                this.hash += this.typeId.hashCode();
            }
            if (this.instanceId != null) {
                this.hash += this.instanceId.hashCode();
            }
        }
        return this.hash;
    }

    private boolean equals(String string1, String string2) {
        return string1 == null && string2 == null || string1 != null && string1.equals(string2);
    }

    private boolean checkId(String id) {
        if (id == null) {
            return true;
        }
        if (id.contains("*")) {
            return false;
        }
        if (id.contains("?")) {
            return false;
        }
        return !id.contains("/");
    }
}

