/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactComparator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.Disassembler;
import org.eclipse.equinox.p2.internal.repository.comparator.Messages;
import org.eclipse.equinox.p2.internal.repository.comparator.Utility;
import org.eclipse.osgi.util.NLS;

public class JarComparator
implements IArtifactComparator {
    private static final String LINE_SEPARATOR = "\n";
    private static final String CLASS_EXTENSION = ".class";
    private static final String JAR_EXTENSION = ".jar";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String PLUGIN_ID = "org.eclipse.equinox.p2.repository.tools";
    private static final String DESTINATION_ARTIFACT_PREFIX = "destinationartifact";
    private static final String SUFFIX_JAR = ".jar";
    private static final String SOURCE_ARTIFACT_PREFIX = "sourceartifact";
    private static final String OSGI_BUNDLE_CLASSIFIER = "osgi.bundle";
    private static final String META_INF = "meta-inf/";
    private static final String DSA_EXT = ".dsa";
    private static final String RSA_EXT = ".rsa";
    private static final String SF_EXT = ".sf";
    private String sourceLocation;
    private String destinationLocation;
    private String descriptorString;

    public IStatus compare(IArtifactRepository source, IArtifactDescriptor sourceDescriptor, IArtifactRepository destination, IArtifactDescriptor destinationDescriptor) {
        this.sourceLocation = URIUtil.toUnencodedString((URI)sourceDescriptor.getRepository().getLocation());
        this.destinationLocation = URIUtil.toUnencodedString((URI)destinationDescriptor.getRepository().getLocation());
        this.descriptorString = sourceDescriptor.toString();
        String classifier = sourceDescriptor.getArtifactKey().getClassifier();
        if (!OSGI_BUNDLE_CLASSIFIER.equals(classifier)) {
            return Status.OK_STATUS;
        }
        classifier = destinationDescriptor.getArtifactKey().getClassifier();
        if (!OSGI_BUNDLE_CLASSIFIER.equals(classifier)) {
            return Status.OK_STATUS;
        }
        File firstTempFile = null;
        File secondTempFile = null;
        try {
            firstTempFile = this.getLocalJarFile(source, sourceDescriptor, SOURCE_ARTIFACT_PREFIX);
            secondTempFile = this.getLocalJarFile(destination, destinationDescriptor, DESTINATION_ARTIFACT_PREFIX);
            IStatus iStatus = this.compare(firstTempFile, secondTempFile);
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            if (firstTempFile != null) {
                firstTempFile.delete();
            }
            if (secondTempFile != null) {
                secondTempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus compare(File sourceFile, File destinationFile) {
        block18: {
            firstFile = null;
            secondFile = null;
            firstFile = new ZipFile(sourceFile);
            secondFile = new ZipFile(destinationFile);
            firstFileSize = firstFile.size();
            secondFileSize = secondFile.size();
            if (firstFileSize == secondFileSize) ** GOTO lbl27
            var19_9 = this.newErrorStatus(NLS.bind((String)Messages.differentNumberOfEntries, (Object[])new String[]{this.descriptorString, this.sourceLocation, Integer.toString(firstFileSize), this.destinationLocation, Integer.toString(secondFileSize)}));
            ** GOTO lbl24
            {
                catch (CoreException e) {
                    var19_11 = e.getStatus();
                    Utility.close(firstFile);
                    Utility.close(secondFile);
                    return var19_11;
                }
                catch (IOException e) {
                    try {
                        var19_12 = this.newErrorStatus(NLS.bind((String)Messages.ioexception, (Object[])new String[]{sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()}), e);
                    }
                    catch (Throwable var18_25) {
                        Utility.close(firstFile);
                        Utility.close(secondFile);
                        throw var18_25;
lbl24:
                        // 1 sources

                        Utility.close(firstFile);
                        Utility.close(secondFile);
                        return var19_9;
lbl27:
                        // 1 sources

                        enumeration = firstFile.entries();
                        while (enumeration.hasMoreElements()) {
                            entry = enumeration.nextElement();
                            entryName = entry.getName();
                            entry2 = secondFile.getEntry(entryName);
                            if (entry.isDirectory() || entry2 == null) ** GOTO lbl67
                            lowerCase = entryName.toLowerCase();
                            if (this.isSigningEntry(lowerCase)) continue;
                            firstStream = null;
                            secondStream = null;
                            try {
                                firstStream = new BufferedInputStream(firstFile.getInputStream(entry));
                                secondStream = new BufferedInputStream(secondFile.getInputStream(entry2));
                                result = false;
                                if (lowerCase.endsWith(".class")) {
                                    try {
                                        result = this.compareClasses(firstStream, entry.getSize(), secondStream, entry2.getSize());
                                    }
                                    catch (ClassFormatException e) {
                                        var17_22 = this.newErrorStatus(NLS.bind((String)Messages.differentEntry, (Object[])new String[]{entryName, this.descriptorString, this.sourceLocation}), e);
                                        Utility.close(firstStream);
                                        Utility.close(secondStream);
                                        Utility.close(firstFile);
                                        Utility.close(secondFile);
                                        return var17_22;
                                    }
                                } else {
                                    result = lowerCase.endsWith(".jar") != false ? this.compareNestedJars(firstStream, entry.getSize(), secondStream, entry2.getSize(), entryName) : (lowerCase.endsWith(".properties") != false ? this.compareProperties(firstStream, secondStream) : (entryName.equalsIgnoreCase("META-INF/MANIFEST.MF") != false ? this.compareManifest(firstStream, secondStream) : this.compareBytes(firstStream, entry.getSize(), secondStream, entry2.getSize())));
                                }
                                if (result) ** GOTO lbl64
                                var17_23 = this.newErrorStatus(NLS.bind((String)Messages.differentEntry, (Object[])new String[]{entryName, this.descriptorString, this.sourceLocation}));
                            }
                            catch (Throwable var16_24) {}
                            Utility.close(firstStream);
                            Utility.close(secondStream);
                            Utility.close(firstFile);
                            Utility.close(secondFile);
                            return var17_23;
                            {
                                Utility.close(firstStream);
                                Utility.close(secondStream);
                                throw var16_24;
lbl64:
                                // 1 sources

                                Utility.close(firstStream);
                                Utility.close(secondStream);
                                continue;
lbl67:
                                // 1 sources

                                if (entry.isDirectory()) continue;
                                var19_10 = this.newErrorStatus(NLS.bind((String)Messages.missingEntry, (Object[])new String[]{entryName, this.descriptorString, this.sourceLocation}));
                            }
                            Utility.close(firstFile);
                            Utility.close(secondFile);
                            return var19_10;
                        }
                        break block18;
                    }
                    Utility.close(firstFile);
                    Utility.close(secondFile);
                    return var19_12;
                }
            }
        }
        Utility.close(firstFile);
        Utility.close(secondFile);
        return Status.OK_STATUS;
    }

    private boolean compareManifest(InputStream firstStream, InputStream secondStream) throws IOException {
        Manifest manifest = new Manifest(firstStream);
        Manifest manifest2 = new Manifest(secondStream);
        if (manifest == null || manifest2 == null) {
            return true;
        }
        Attributes attributes = manifest.getMainAttributes();
        Attributes attributes2 = manifest2.getMainAttributes();
        if (attributes.size() != attributes2.size()) {
            return false;
        }
        Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            Object value2 = attributes2.get(entry.getKey());
            if (value2 == null) {
                return false;
            }
            if (value2.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean compareClasses(InputStream stream1, long size1, InputStream stream2, long size2) throws ClassFormatException, IOException {
        Disassembler disassembler = new Disassembler();
        byte[] firstEntryClassFileBytes = Utility.getInputStreamAsByteArray(stream1, (int)size1);
        byte[] secondEntryClassFileBytes = Utility.getInputStreamAsByteArray(stream2, (int)size2);
        String contentsFile1 = disassembler.disassemble(firstEntryClassFileBytes, LINE_SEPARATOR, 9);
        String contentsFile2 = disassembler.disassemble(secondEntryClassFileBytes, LINE_SEPARATOR, 9);
        return contentsFile1.equals(contentsFile2);
    }

    private boolean compareNestedJars(InputStream stream1, long size1, InputStream stream2, long size2, String entry) throws CoreException, IOException {
        File firstTempFile = this.getLocalJarFile(stream1, entry, size1);
        File secondTempFile = this.getLocalJarFile(stream2, entry, size2);
        try {
            IStatus status = this.compare(firstTempFile, secondTempFile);
            if (!status.isOK()) {
                throw new CoreException(status);
            }
        }
        finally {
            if (firstTempFile != null) {
                firstTempFile.delete();
            }
            if (secondTempFile != null) {
                secondTempFile.delete();
            }
        }
        return true;
    }

    private boolean compareProperties(InputStream stream1, InputStream stream2) {
        Properties props1 = this.loadProperties(stream1);
        Properties props2 = this.loadProperties(stream2);
        if (props1.size() != props2.size()) {
            return false;
        }
        props1.keys();
        Iterator<Object> iterator = props1.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!props2.containsKey(key)) {
                return false;
            }
            if (props1.getProperty(key).equals(props2.getProperty(key))) continue;
            return false;
        }
        return true;
    }

    private boolean compareBytes(InputStream firstStream, long size1, InputStream secondStream, long size2) throws IOException {
        byte[] firstBytes = Utility.getInputStreamAsByteArray(firstStream, (int)size1);
        byte[] secondBytes = Utility.getInputStreamAsByteArray(secondStream, (int)size2);
        return Arrays.equals(firstBytes, secondBytes);
    }

    private Properties loadProperties(InputStream input) {
        Properties result = new Properties();
        try {
            result.load(input);
        }
        catch (IOException iOException) {}
        return result;
    }

    private String normalize(String entryName) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = entryName.toCharArray();
        int i = 0;
        int max = chars.length;
        while (i < max) {
            char currentChar = chars[i];
            if (!Character.isJavaIdentifierPart(currentChar)) {
                buffer.append('_');
            } else {
                buffer.append(currentChar);
            }
            ++i;
        }
        return String.valueOf(buffer);
    }

    private IStatus newErrorStatus(String message, Exception e) {
        return new Status(4, PLUGIN_ID, message, (Throwable)e);
    }

    private IStatus newErrorStatus(String message) {
        return this.newErrorStatus(message, null);
    }

    private File getLocalJarFile(IArtifactRepository repository, IArtifactDescriptor descriptor, String prefix) throws CoreException {
        File file = null;
        BufferedOutputStream stream = null;
        try {
            try {
                file = File.createTempFile(prefix, ".jar");
                stream = new BufferedOutputStream(new FileOutputStream(file));
                IStatus status = repository.getArtifact(descriptor, (OutputStream)stream, (IProgressMonitor)new NullProgressMonitor());
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                stream.flush();
            }
            catch (FileNotFoundException e) {
                throw new CoreException(this.newErrorStatus("FileNotFoundException", e));
            }
            catch (IOException e) {
                throw new CoreException(this.newErrorStatus("IOException", e));
            }
        }
        catch (Throwable throwable) {
            Utility.close(stream);
            throw throwable;
        }
        Utility.close(stream);
        return file;
    }

    private File getLocalJarFile(InputStream inputStream, String entry, long size) throws IOException {
        byte[] firstEntryClassFileBytes = Utility.getInputStreamAsByteArray(inputStream, (int)size);
        File tempFile = null;
        BufferedOutputStream stream = null;
        try {
            tempFile = File.createTempFile(SOURCE_ARTIFACT_PREFIX + this.normalize(entry), ".jar");
            stream = new BufferedOutputStream(new FileOutputStream(tempFile));
            stream.write(firstEntryClassFileBytes);
            stream.flush();
        }
        catch (Throwable throwable) {
            Utility.close(stream);
            throw throwable;
        }
        Utility.close(stream);
        return tempFile;
    }

    private boolean isSigningEntry(String entry) {
        return entry.startsWith(META_INF) && (entry.endsWith(SF_EXT) || entry.endsWith(RSA_EXT) || entry.endsWith(DSA_EXT));
    }
}

