/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.Collection;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.marker.Markable;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.swt.IEmbeddedTitleBarListener;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.EmbeddedTitlebarRenderer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedTitleBar
extends Canvas {
    private boolean windowActive;
    private boolean pressed;
    private boolean hover;
    private boolean closeButtonPressed;
    private boolean closeButtonHover;
    private boolean closeable;
    private Image image;
    private String title;
    private Collection<? extends IMarker> markers;
    protected ListenerList<IEmbeddedTitleBarListener> titleBarListeners;

    public EmbeddedTitleBar(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addListeners();
        this.titleBarListeners = new ListenerList(IEmbeddedTitleBarListener.class);
    }

    protected void addListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                EmbeddedTitleBar.this.onPaint(e);
            }
        });
    }

    private void onPaint(PaintEvent e) {
        GC gc = e.gc;
        this.getLnfTitlebarRenderer().setActive(this.isWindowActive());
        this.getLnfTitlebarRenderer().setCloseable(this.isCloseable());
        this.getLnfTitlebarRenderer().setPressed(this.isPressed());
        this.getLnfTitlebarRenderer().setHover(this.isHover());
        this.getLnfTitlebarRenderer().setCloseButtonPressed(this.isCloseButtonPressed());
        this.getLnfTitlebarRenderer().setCloseButtonHover(this.isCloseButtonHover());
        this.getLnfTitlebarRenderer().setImage(this.getImage());
        this.getLnfTitlebarRenderer().setTitle(this.getTitle());
        this.getLnfTitlebarRenderer().setMarkers(this.getMarkers());
        Point titlebarSize = this.getLnfTitlebarRenderer().computeSize(gc, this.getBounds().width, 0);
        Rectangle titlebarBounds = new Rectangle(this.getBounds().x, 0, titlebarSize.x, titlebarSize.y);
        this.getLnfTitlebarRenderer().setBounds(titlebarBounds);
        this.getLnfTitlebarRenderer().paint(gc, (Object)this);
    }

    protected EmbeddedTitlebarRenderer getLnfTitlebarRenderer() {
        EmbeddedTitlebarRenderer renderer = (EmbeddedTitlebarRenderer)LnfManager.getLnf().getRenderer("SubModuleView.titlebarRenderer");
        if (renderer == null) {
            renderer = new EmbeddedTitlebarRenderer();
        }
        return renderer;
    }

    public void addEmbeddedTitleBarListener(IEmbeddedTitleBarListener listener) {
        this.titleBarListeners.add((Object)listener);
    }

    public void removeEmbeddedTitleBarListener(IEmbeddedTitleBarListener listener) {
        this.titleBarListeners.remove((Object)listener);
    }

    public Point getSize() {
        Point size = super.getSize();
        GC gc = new GC((Drawable)this);
        size = this.getLnfTitlebarRenderer().computeSize(gc, size.x, size.y);
        gc.dispose();
        return size;
    }

    public boolean isFocusControl() {
        return false;
    }

    public boolean isWindowActive() {
        return this.windowActive;
    }

    public void setWindowActive(boolean active) {
        if (this.hasChanged(this.windowActive, active)) {
            this.windowActive = active;
            this.redraw();
        }
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        if (this.hasChanged(this.pressed, pressed)) {
            this.pressed = pressed;
            this.redraw();
        }
    }

    public boolean isHover() {
        return this.hover;
    }

    public void setHover(boolean hover) {
        if (this.hasChanged(this.hover, hover)) {
            this.hover = hover;
            this.redraw();
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        if (this.hasChanged(this.closeable, closeable)) {
            this.closeable = closeable;
            this.redraw();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (this.hasChanged(this.title, title)) {
            this.title = title;
            this.redraw();
        }
    }

    public void setImage(Image image) {
        if (this.hasChanged(this.image, image)) {
            this.image = image;
            this.redraw();
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setMarkers(Collection<? extends IMarker> markers) {
        this.markers = markers;
    }

    public Collection<? extends IMarker> getMarkers() {
        return this.markers;
    }

    public <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        return Markable.getMarkersOfType(this.getMarkers(), type);
    }

    protected boolean isOverClose(Point point) {
        if (!this.isCloseable()) {
            return false;
        }
        boolean inside = this.getLnfTitlebarRenderer().isInsideCloseButton(point);
        return inside;
    }

    public boolean isTextClipped() {
        EmbeddedTitlebarRenderer titlebarRenderer = this.getLnfTitlebarRenderer();
        titlebarRenderer.setBounds(this.getBounds());
        GC gc = new GC((Drawable)this);
        String clippedText = titlebarRenderer.getClippedText(gc, this.title);
        gc.dispose();
        if (StringUtils.isEmpty((CharSequence)this.title)) {
            return false;
        }
        return !this.title.equals(clippedText);
    }

    private boolean hasChanged(Object oldValue, Object newValue) {
        return oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue);
    }

    public void setCloseButtonPressed(boolean closeButtonPressed) {
        if (this.hasChanged(this.closeButtonPressed, closeButtonPressed)) {
            this.closeButtonPressed = closeButtonPressed;
            this.redraw();
        }
    }

    public boolean isCloseButtonPressed() {
        return this.closeButtonPressed;
    }

    public void setCloseButtonHover(boolean closeButtonHover) {
        if (this.hasChanged(this.closeButtonHover, closeButtonHover)) {
            this.closeButtonHover = closeButtonHover;
            this.redraw();
        }
    }

    public boolean isCloseButtonHover() {
        return this.closeButtonHover;
    }
}

