/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf;

import org.eclipse.riena.ui.swt.lnf.FontLnfResource;
import org.eclipse.riena.ui.swt.lnf.ILnfFontDescriptor;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class FontDescriptor
implements ILnfFontDescriptor {
    private String key;
    private int height;
    private int style;
    private final RienaDefaultLnf lnf;

    public FontDescriptor(RienaDefaultLnf lnf) {
        this.lnf = lnf;
        this.setHeight(-1);
    }

    public FontDescriptor(String key, int height, int style, RienaDefaultLnf lnf) {
        this(lnf);
        this.setKey(key);
        this.setHeight(height);
        this.setStyle(style);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (height < 0) {
            height = this.getDefaultHeight();
        }
        this.height = height;
        assert (this.height >= 0);
    }

    protected Integer getDefaultHeight() {
        return this.lnf.getIntegerSetting("FontDescriptor.defaultHeight");
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public Font getFont() {
        Font font = this.lnf.getFont(this.toString());
        if (font != null) {
            return font;
        }
        return this.updateFont();
    }

    private Font updateFont() {
        if (this.key == null) {
            return null;
        }
        Font font = this.lnf.getFont(this.key);
        if (font == null || font.getFontData().length == 0) {
            return null;
        }
        String fontName = font.getFontData()[0].getName();
        FontData fontData = new FontData(fontName, this.height, this.style);
        FontLnfResource fontResource = new FontLnfResource(fontData);
        this.lnf.getResourceTable().put(this.toString(), fontResource);
        return this.getFont();
    }

    public String toString() {
        return "FontDescriptor [key=" + this.key + ", height=" + this.height + ", style=" + this.style + "]";
    }
}

