/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.DatePickerComposite;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.riena.ui.swt.MessageBox;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class UIControlsFactory {
    public static final String KEY_LNF_STYLE = "lnfStyle";
    public static final String LNF_STYLE_SECTION_LABEL = "sectionLabel";
    public static final String KEY_TYPE = "type";
    public static final String TYPE_NUMERIC = "numeric";
    public static final String TYPE_DECIMAL = "decimal";
    public static final String TYPE_DATE = "date";
    protected static final Color SHARED_BG_COLOR = LnfManager.getLnf().getColor("SubModule.background");

    static {
        Assert.isNotNull((Object)SHARED_BG_COLOR);
    }

    protected UIControlsFactory() {
    }

    public static MenuItem createMenuItem(Menu parent, String text, int style) {
        MenuItem item = new MenuItem(parent, style);
        item.setText(text);
        return item;
    }

    public static MenuItem createMenuItem(Menu parent, String text) {
        MenuItem item = new MenuItem(parent, 0);
        item.setText(text);
        return item;
    }

    public static MenuItem createMenuItem(Menu parent, String text, String bindingId) {
        MenuItem item = new MenuItem(parent, 0);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(item, bindingId);
        item.setText(text);
        return item;
    }

    public static Menu createMenu(Control parent) {
        Menu item = new Menu(parent);
        return item;
    }

    public static Menu createMenu(MenuItem parent) {
        Menu item = new Menu(parent);
        return item;
    }

    public static Label createLabel(Composite parent, String text) {
        return UIControlsFactory.createLabel(parent, text, 0);
    }

    public static Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        label.setText(text);
        label.setBackground(SHARED_BG_COLOR);
        return label;
    }

    public static Label createLabel(Composite parent, String text, int style, String bindingId) {
        Label label = UIControlsFactory.createLabel(parent, text, style);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(label, bindingId);
        return label;
    }

    public static Label createLabel(Composite parent, String text, String bindingId) {
        return UIControlsFactory.createLabel(parent, text, 0, bindingId);
    }

    public static Link createLink(Composite parent) {
        return UIControlsFactory.createLink(parent, 0);
    }

    public static Link createLink(Composite parent, int style) {
        Link result = new Link(parent, 0);
        result.setBackground(SHARED_BG_COLOR);
        return result;
    }

    public static Link createLink(Composite parent, int style, String bindingId) {
        Link result = UIControlsFactory.createLink(parent, style);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(result, bindingId);
        return result;
    }

    public static Text createText(Composite parent) {
        return new Text(parent, 2052);
    }

    public static Text createText(Composite parent, int style) {
        return new Text(parent, style | 0x800);
    }

    public static Text createText(Composite parent, int style, String bindingId) {
        Text text = new Text(parent, style | 0x800);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(text, bindingId);
        return text;
    }

    public static Text createTextDate(Composite parent) {
        Text result = new Text(parent, 133124);
        result.setData(KEY_TYPE, (Object)TYPE_DATE);
        return result;
    }

    public static Text createTextDate(Composite parent, String bindingId) {
        Text result = UIControlsFactory.createTextDate(parent);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(result, bindingId);
        return result;
    }

    public static DatePickerComposite createDatePickerComposite(Composite parent) {
        DatePickerComposite result = new DatePickerComposite(parent, 131076);
        result.setData(KEY_TYPE, TYPE_DATE);
        return result;
    }

    public static DatePickerComposite createDatePickerComposite(Composite parent, String bindingId) {
        DatePickerComposite result = UIControlsFactory.createDatePickerComposite(parent);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)result, bindingId);
        return result;
    }

    public static Text createTextDecimal(Composite parent) {
        Text result = new Text(parent, 133124);
        result.setData(KEY_TYPE, (Object)TYPE_DECIMAL);
        return result;
    }

    public static Text createTextDecimal(Composite parent, String bindingId) {
        Text result = UIControlsFactory.createTextDecimal(parent);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(result, bindingId);
        return result;
    }

    public static Text createTextNumeric(Composite parent) {
        Text result = new Text(parent, 133124);
        result.setData(KEY_TYPE, (Object)TYPE_NUMERIC);
        return result;
    }

    public static Text createTextNumeric(Composite parent, String bindingId) {
        Text result = UIControlsFactory.createTextNumeric(parent);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(result, bindingId);
        return result;
    }

    public static Text createTextMultiWrap(Composite parent, boolean hScroll, boolean vScroll) {
        return UIControlsFactory.createTextMulti(parent, 64, hScroll, vScroll);
    }

    public static Text createTextMulti(Composite parent, boolean hScroll, boolean vScroll) {
        return UIControlsFactory.createTextMulti(parent, 0, hScroll, vScroll);
    }

    public static Text createTextMulti(Composite parent, int style, boolean hScroll, boolean vScroll) {
        int txStyle = style | 2 | 0x800;
        if (hScroll) {
            txStyle |= 0x100;
        }
        if (vScroll) {
            txStyle |= 0x200;
        }
        return new Text(parent, txStyle);
    }

    public static Text createTextMulti(Composite parent, boolean hScroll, boolean vScroll, String bindingId) {
        Text text = UIControlsFactory.createTextMulti(parent, hScroll, vScroll);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(text, bindingId);
        return text;
    }

    public static Browser createBrowser(Composite parent, int style) {
        return new Browser(parent, style);
    }

    public static Browser createBrowser(Composite parent, int style, String bindingId) {
        Browser result = UIControlsFactory.createBrowser(parent, style);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(result, bindingId);
        return result;
    }

    public static Button createButton(Composite parent) {
        return new Button(parent, 8);
    }

    public static Button createButton(Composite parent, String text) {
        Button result = new Button(parent, 8);
        result.setText(text);
        return result;
    }

    public static Button createButton(Composite parent, String text, String bindingId) {
        Button result = UIControlsFactory.createButton(parent, text);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(result, bindingId);
        return result;
    }

    public static Button createButtonToggle(Composite parent) {
        return new Button(parent, 2);
    }

    public static Button createButtonToggle(Composite parent, String bindingId) {
        Button button = UIControlsFactory.createButtonToggle(parent);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(button, bindingId);
        return button;
    }

    public static Button createButtonCheck(Composite parent) {
        Button button = new Button(parent, 32);
        button.setBackground(SHARED_BG_COLOR);
        return button;
    }

    public static Button createButtonCheck(Composite parent, String bindingId) {
        Button button = UIControlsFactory.createButtonCheck(parent);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(button, bindingId);
        return button;
    }

    public static Button createButtonRadio(Composite parent) {
        Button button = new Button(parent, 16);
        button.setBackground(SHARED_BG_COLOR);
        return button;
    }

    public static Button createButtonRadio(Composite parent, String bindingId) {
        Button button = UIControlsFactory.createButtonRadio(parent);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(button, bindingId);
        return button;
    }

    public static DateTime createCalendar(Composite parent) {
        DateTime result = new DateTime(parent, 1024);
        result.setBackground(SHARED_BG_COLOR);
        return result;
    }

    public static DateTime createCalendar(Composite parent, String bindingId) {
        DateTime result = UIControlsFactory.createCalendar(parent);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(result, bindingId);
        return result;
    }

    public static CCombo createCCombo(Composite parent) {
        return new CCombo(parent, 2056);
    }

    public static CCombo createCCombo(Composite parent, String bindingId) {
        CCombo combo = UIControlsFactory.createCCombo(parent);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(combo, bindingId);
        return combo;
    }

    public static Combo createCombo(Composite parent) {
        return new Combo(parent, 2060);
    }

    public static Combo createCombo(Composite parent, String bindingId) {
        Combo combo = UIControlsFactory.createCombo(parent);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(combo, bindingId);
        return combo;
    }

    public static Composite createComposite(Composite parent) {
        return UIControlsFactory.createComposite(parent, 0);
    }

    public static Composite createComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setBackground(SHARED_BG_COLOR);
        return composite;
    }

    public static CompositeTable createCompositeTable(Composite parent, int style) {
        CompositeTable result = new CompositeTable(parent, style);
        result.setBackground(SHARED_BG_COLOR);
        return result;
    }

    public static ChoiceComposite createChoiceComposite(Composite parent, int style, boolean multipleSelection) {
        return new ChoiceComposite(parent, style, multipleSelection);
    }

    public static ChoiceComposite createChoiceComposite(Composite parent, int style, boolean multipleSelection, String bindingId) {
        ChoiceComposite composite = UIControlsFactory.createChoiceComposite(parent, style, multipleSelection);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)composite, bindingId);
        return composite;
    }

    public static DateTime createDate(Composite parent, int style) {
        DateTime result = new DateTime(parent, 0x24 | style);
        result.setBackground(SHARED_BG_COLOR);
        return result;
    }

    public static DateTime createDate(Composite parent, int style, String bindingId) {
        DateTime result = UIControlsFactory.createDate(parent, style);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(result, bindingId);
        return result;
    }

    public static Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        group.setBackground(SHARED_BG_COLOR);
        return group;
    }

    public static List createList(Composite parent, boolean hScroll, boolean vScroll) {
        int style = 2050;
        if (hScroll) {
            style |= 0x100;
        }
        if (vScroll) {
            style |= 0x200;
        }
        return new List(parent, style);
    }

    public static List createList(Composite parent, boolean hScroll, boolean vScroll, String bindingId) {
        List list = UIControlsFactory.createList(parent, hScroll, vScroll);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(list, bindingId);
        return list;
    }

    public static MasterDetailsComposite createMasterDetails(Composite parent) {
        return new MasterDetailsComposite(parent, 0);
    }

    public static MasterDetailsComposite createMasterDetails(Composite parent, String bindingId) {
        MasterDetailsComposite masterDetails = new MasterDetailsComposite(parent, 0);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)masterDetails, bindingId);
        return masterDetails;
    }

    public static MessageBox createMessageBox(Composite parent) {
        return new MessageBox(parent);
    }

    public static Shell createShell(Display display) {
        Assert.isNotNull((Object)display);
        Shell shell = new Shell(display);
        shell.setBackground(SHARED_BG_COLOR);
        return shell;
    }

    public static DateTime createTime(Composite parent, int style) {
        DateTime result = new DateTime(parent, 0x80 | style);
        result.setBackground(SHARED_BG_COLOR);
        return result;
    }

    public static DateTime createTime(Composite parent, int style, String bindingId) {
        DateTime result = UIControlsFactory.createTime(parent, style);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(result, bindingId);
        return result;
    }

    public static Tree createTree(Composite parent, int style) {
        return new Tree(parent, style);
    }

    public static Tree createTree(Composite parent, int style, String bindingId) {
        Tree tree = UIControlsFactory.createTree(parent, style);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(tree, bindingId);
        return tree;
    }

    public static Table createTable(Composite parent, int style) {
        return new Table(parent, style);
    }

    public static Table createTable(Composite parent, int style, String bindingId) {
        Table table = UIControlsFactory.createTable(parent, style);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(table, bindingId);
        return table;
    }

    public static int getWidthHint(Button button) {
        GC gc = new GC((Drawable)button.getDisplay());
        try {
            FontMetrics fm = gc.getFontMetrics();
            int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fm, (int)61);
            Point minSize = button.computeSize(-1, -1, true);
            int n = Math.max(widthHint, minSize.x);
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    public static int getWidthHint(Text text, int numChars) {
        GC gc = new GC((Drawable)text.getDisplay());
        try {
            FontMetrics fm = gc.getFontMetrics();
            int widthHint = fm.getAverageCharWidth() * numChars;
            Point minSize = text.computeSize(-1, -1, true);
            int n = Math.max(widthHint, minSize.x);
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    public static int getHeightHint(List list, int numItems) {
        Assert.isLegal((numItems > 0 ? 1 : 0) != 0, (String)"numItems must be greater than 0");
        int items = list.getItemHeight() * numItems;
        return items;
    }
}

