/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.BrowserRidget;
import org.eclipse.riena.ui.ridgets.IBrowserRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class BrowserRidgetTest
extends AbstractSWTRidgetTest {
    protected Widget createWidget(Composite parent) {
        return new Browser(parent, 0);
    }

    protected IBrowserRidget createRidget() {
        return new BrowserRidget();
    }

    protected Browser getWidget() {
        return (Browser)super.getWidget();
    }

    protected IBrowserRidget getRidget() {
        return (IBrowserRidget)super.getRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        BrowserRidgetTest.assertSame(BrowserRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testSetFocusable() {
        this.ok();
    }

    public void testRequestFocus() {
        this.ok();
    }

    public void testBindToModel() {
        IBrowserRidget ridget = this.getRidget();
        String url1 = "http://www.redview.org";
        String url2 = "http://www.eclipse.org";
        StringBean bean = new StringBean(url1);
        ridget.bindToModel((Object)bean, "value");
        BrowserRidgetTest.assertNull((Object)ridget.getUrl());
        ridget.updateFromModel();
        BrowserRidgetTest.assertEquals((String)url1, (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)url1, (String)ridget.getUrl());
        bean.setValue(url2);
        BrowserRidgetTest.assertEquals((String)url2, (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)url1, (String)ridget.getUrl());
        ridget.updateFromModel();
        BrowserRidgetTest.assertEquals((String)url2, (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)url2, (String)ridget.getUrl());
        ridget.setUrl(url1);
        BrowserRidgetTest.assertEquals((String)url1, (String)bean.getValue());
        BrowserRidgetTest.assertEquals((String)url1, (String)ridget.getUrl());
    }

    public void testSetUrl() {
        IBrowserRidget ridget = this.getRidget();
        ridget.setUrl("http://www.redview.org");
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)ridget.getUrl());
        ridget.setUrl("b o g u s");
        BrowserRidgetTest.assertEquals((String)"b o g u s", (String)ridget.getUrl());
        ridget.setUrl("");
        BrowserRidgetTest.assertEquals((String)"", (String)ridget.getUrl());
        ridget.setUrl(null);
        BrowserRidgetTest.assertEquals(null, (String)ridget.getUrl());
        ridget.setUrl("about:blank");
        BrowserRidgetTest.assertEquals((String)"about:blank", (String)ridget.getUrl());
    }

    public void testSetUrlFiresEvents() {
        IBrowserRidget ridget = this.getRidget();
        String oldValue = ridget.getUrl();
        BrowserRidgetTest.assertFalse((boolean)"http://www.redview.org".equals(ridget.getUrl()));
        this.expectPropertyChangeEvent("url", oldValue, "http://www.redview.org");
        ridget.setUrl("http://www.redview.org");
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setUrl("http://www.redview.org");
        this.verifyPropertyChangeEvents();
    }

    public void testSetUrlOnOutputOnly() {
        IBrowserRidget ridget = this.getRidget();
        BrowserRidgetTest.assertNull((Object)ridget.getUrl());
        ridget.setOutputOnly(true);
        ridget.setUrl("http://www.redview.org");
        ridget.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println(String.valueOf(evt.getPropertyName()) + " " + evt.getNewValue());
            }
        });
        BrowserRidgetTest.assertEquals((String)"http://www.redview.org", (String)ridget.getUrl());
    }
}

