/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.riena.beans.common.DateBean;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.DateTextRidget;
import org.eclipse.riena.internal.ui.swt.test.TestUtils;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.ridgets.IDateTextRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DateTextRidgetTest
extends AbstractSWTRidgetTest {
    protected IRidget createRidget() {
        DateTextRidget result = new DateTextRidget();
        result.setFormat("dd.MM.yyyy");
        return result;
    }

    protected IDateTextRidget getRidget() {
        return (IDateTextRidget)super.getRidget();
    }

    protected Control createWidget(Composite parent) {
        Text result = new Text((Composite)this.getShell(), 133124);
        result.setData("type", (Object)"date");
        result.setLayoutData((Object)new RowData(100, -1));
        return result;
    }

    protected Text getWidget() {
        return (Text)super.getWidget();
    }

    public void testEmptyText() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setFormat("dd.MM");
        ridget.updateFromModel();
        DateTextRidgetTest.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        ridget.setFormat("dd.MM.yy");
        ridget.updateFromModel();
        DateTextRidgetTest.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        ridget.setFormat("dd.MM.yyyy");
        ridget.updateFromModel();
        DateTextRidgetTest.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
        ridget.setFormat("dd.MM.yyyy HH:mm");
        ridget.updateFromModel();
        DateTextRidgetTest.assertTrue((boolean)ridget.getMarkersOfType(ErrorMarker.class).isEmpty());
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        DateTextRidgetTest.assertSame(DateTextRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testDelete() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setFormat("dd.MM.yyyy");
        this.assertText("^01.10.2008", 127, " ^1.10.2008");
        this.assertText("0^1.10.2008", 127, " 0^.10.2008");
        this.assertText("01.10.200^8", 127, "01.10. 200^");
        this.assertText("01.10.2008^", 127, "01.10.2008^");
        this.assertText("01.10^.2008", 127, "01.10. ^008");
        this.assertText("01.10^. 008", 127, "01.10.  ^08");
        this.assertText("01.10^.^2008", 127, "01.10^.2008");
        this.assertText("01.10^.2^008", 127, "01.10^. 008");
        this.assertText("01.1^0.2^008", 127, "01. 1^. 008");
        this.assertText("^01.10.2008^", 127, "  ^.  .    ");
        this.assertText("^01.10.2008", "\b", "^01.10.2008");
        this.assertText("0^1.10.2008", "\b", " ^1.10.2008");
        this.assertText("01.10.200^8", "\b", "01.10. 20^8");
        this.assertText("01.10.2008^", "\b", "01.10. 200^");
        this.assertText("01.10.^2008", "\b", "01. 1^.2008");
        this.assertText("01. 1.^2008", "\b", "01.  ^.2008");
        this.assertText("01.10^.^2008", "\b", "01.10^.2008");
        this.assertText("01.10^.2^008", "\b", "01.10^. 008");
        this.assertText("01.1^0.2^008", "\b", "01. 1^. 008");
        this.assertText("^01.10.2008^", "\b", "  ^.  .    ");
        this.assertText("^  .  .    ", 127, "  ^.  .    ");
        this.assertText("  ^.  .    ", 127, "  .  ^.    ");
        this.assertText("  . ^ .    ", 127, "  .  ^.    ");
        this.assertText("  .  ^.    ", 127, "  .  .    ^");
        this.assertText("  .  .    ^", "\b", "  .  ^.    ");
        this.assertText("  . ^ .    ", "\b", "  ^.  .    ");
        this.assertText("  ^.  .    ", "\b", "  ^.  .    ");
        this.assertText(" ^ .  .    ", "\b", " ^ .  .    ");
    }

    public void testReplace() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setFormat("dd.MM.yyyy");
        this.assertText("01.10^.^2008", "1", "01.10^.2008");
        this.assertText("01.10^.^2008", ".", "01.10.^2008");
        this.assertText("01.10^.2^008", "1", "01.10.1^008");
        this.assertText("01.1^0.^2008", "3", "01.13^.2008");
        this.assertText("01.1^0.2^008", "3", "01.13^. 008");
        this.assertText("^01^.10.2008", "3", " 3^.10.2008");
        this.assertText("^01.^10.2008", "3", " 3^.10.2008");
        this.assertText("^01.1^0.2008", "3", " 3^. 0.2008");
        this.assertText("^01.10.2^008", "3", " 3^.  . 008");
        this.assertText("^01.10.2008^", "3", " 3^.  .    ");
    }

    public void testInsert() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setFormat("dd.MM.yyyy");
        this.assertText("  ^.  .    ", "01102008", "01.10.2008^");
        this.assertText(" ^ .  .    ", "01.10.2008", "01.10.2008^");
        this.assertText("^  .  .    ", "01.10.20081234", "01.10.2008^");
        this.assertText("  ^.10.2008", "0123", "01^.10.2008");
        this.assertText("  ^.  .2008", "1208", "12.08^.2008");
        this.assertText("  .  ^.2008", "1208", "  .12^.2008");
        this.assertText("01.  .^2008", "10", "01.  .^2008");
        this.assertText("  .  .    ^", "2008", "  .  .2008^");
        this.assertText("  .  ^.    ", "102008", "  .10.2008^");
    }

    public void testSetText() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setFormat("dd.MM.yyyy");
        ridget.setText("01.10.2008");
        DateTextRidgetTest.assertEquals((String)"01.10.2008", (String)ridget.getText());
        ridget.setText("01.10");
        DateTextRidgetTest.assertEquals((String)"01.10.    ", (String)ridget.getText());
        ridget.setText("22.22.2222");
        DateTextRidgetTest.assertEquals((String)"22.22.2222", (String)ridget.getText());
        ridget.setText("");
        DateTextRidgetTest.assertEquals((String)"  .  .    ", (String)ridget.getText());
        ridget.setText("  .10.");
        DateTextRidgetTest.assertEquals((String)"  .10.    ", (String)ridget.getText());
        ridget.setText("  .  .");
        DateTextRidgetTest.assertEquals((String)"  .  .    ", (String)ridget.getText());
        try {
            ridget.setText("abc");
            DateTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setText("12102008");
            DateTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setText("12/10/2008");
            DateTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.setText("12.ab");
            DateTextRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetTextNull() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setFormat("dd.MM.yyyy");
        ridget.setText("01.10.2008");
        DateTextRidgetTest.assertEquals((String)"01.10.2008", (String)ridget.getText());
        ridget.setText(null);
        DateTextRidgetTest.assertEquals((String)"  .  .    ", (String)ridget.getText());
    }

    public void testSetFormatAfterSetText() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setFormat("dd.MM.yyyy");
        Text control = this.getWidget();
        StringBean bean = new StringBean();
        ridget.bindToModel((Object)bean, "value");
        ridget.setText("01.10.2008");
        DateTextRidgetTest.assertEquals((String)"01.10.2008", (String)control.getText());
        DateTextRidgetTest.assertEquals((String)"01.10.2008", (String)ridget.getText());
        DateTextRidgetTest.assertEquals((String)"01.10.2008", (String)bean.getValue());
        ridget.setFormat("HH:mm");
        DateTextRidgetTest.assertEquals((String)"  :  ", (String)control.getText());
        DateTextRidgetTest.assertEquals((String)"  :  ", (String)ridget.getText());
        DateTextRidgetTest.assertEquals((String)"  :  ", (String)bean.getValue());
    }

    public void testUpdateFromModel() {
        IDateTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        ridget.setFormat("dd.MM.yyyy");
        StringBean bean = new StringBean("12.10.2008");
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        DateTextRidgetTest.assertEquals((String)"12.10.2008", (String)control.getText());
        DateTextRidgetTest.assertEquals((String)"12.10.2008", (String)ridget.getText());
        DateTextRidgetTest.assertEquals((String)"12.10.2008", (String)bean.getValue());
        bean.setValue("  .12");
        ridget.updateFromModel();
        DateTextRidgetTest.assertEquals((String)"  .12.    ", (String)control.getText());
        DateTextRidgetTest.assertEquals((String)"  .12.    ", (String)ridget.getText());
        DateTextRidgetTest.assertEquals((String)"  .12", (String)bean.getValue());
        bean.setValue("abc");
        ridget.updateFromModel();
        DateTextRidgetTest.assertEquals((String)"  .12.    ", (String)control.getText());
        DateTextRidgetTest.assertEquals((String)"  .12.    ", (String)control.getText());
        DateTextRidgetTest.assertEquals((String)"abc", (String)bean.getValue());
    }

    public void testBindToDate() {
        IDateTextRidget ridget = this.getRidget();
        Text control = this.getWidget();
        DateBean bean = new DateBean(new Date(0L));
        ridget.bindToModel((Object)bean, "value");
        ridget.updateFromModel();
        DateTextRidgetTest.assertEquals((String)"01.01.1970", (String)control.getText());
        DateTextRidgetTest.assertEquals((String)"01.01.1970", (String)ridget.getText());
        DateTextRidgetTest.assertEquals((Object)new Date(0L), (Object)bean.getValue());
    }

    public void testAutoFillYYYY() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setFormat("dd.MM.yyyy");
        this.assertText("  .  .    ^", "00\t", "  .  .2000");
        this.assertText("  .  .^    ", "01\t", "  .  .2001");
        this.assertText("  .  . ^   ", "29\t", "  .  .2029");
        this.assertText("  .  .    ^", "30\t", "  .  .1930");
        this.assertText("  .  .    ^", "99\t", "  .  .1999");
    }

    public void testAutoFillYYYYWithError() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setFormat("dd.MM.yyyy");
        ridget.setText("31.10.2008");
        DateTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        this.assertText("31.10.    ^", "8\t", "31.10.   8");
        DateTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.setText("31.10.2008");
        DateTextRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        this.assertText("31.10.    ^", "008\t", "31.10. 008");
        DateTextRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
    }

    public void testDoNotFillYY() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setFormat("dd.MM.yy");
        this.assertText("  .  .  ^", "00\t", "  .  .00");
        ridget.setFormat("ddMMyy");
        this.assertText("      ^", "00\t", "    00");
    }

    public void testMandatoryMarker() {
        IDateTextRidget ridget = this.getRidget();
        ridget.setMandatory(true);
        ridget.setFormat("dd.MM.yyyy");
        ridget.setText("31.10.2008");
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, (int)1, (boolean)true);
        ridget.setText(null);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, (int)1, (boolean)false);
        ridget.setMandatory(false);
        TestUtils.assertMandatoryMarker((IMarkableRidget)ridget, (int)0, (boolean)false);
    }

    public void testDateConverterStrategyGetter() {
        DateTextRidget ridget = (DateTextRidget)this.getRidget();
        ridget.setFormat("dd.MM.yyyy");
        DateTextRidget.RidgetAwareDateConverterStrategy strategy = new DateTextRidget.RidgetAwareDateConverterStrategy(ridget);
        DateTextRidgetTest.assertNull((Object)strategy.getDateFromTextField(null));
        DateTextRidgetTest.assertNull((Object)strategy.getDateFromTextField(""));
        DateTextRidgetTest.assertNull((Object)strategy.getDateFromTextField("abcd"));
        DateTextRidgetTest.assertNull((Object)strategy.getDateFromTextField("12.12"));
        Calendar calendar = Calendar.getInstance();
        calendar.set(2009, 11, 24, 0, 0, 0);
        Date expected = calendar.getTime();
        Date result = strategy.getDateFromTextField("24.12.2009");
        DateTextRidgetTest.assertEquals((String)expected.toString(), (String)result.toString());
    }

    public void testDateConverterStrategySetter() {
        DateTextRidget ridget = (DateTextRidget)this.getRidget();
        ridget.setFormat("dd.MM.yyyy HH:mm");
        DateTextRidget.RidgetAwareDateConverterStrategy strategy = new DateTextRidget.RidgetAwareDateConverterStrategy(ridget);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2009, 11, 24, 0, 0, 0);
        Date date = calendar.getTime();
        strategy.setDateToTextField(date);
        DateTextRidgetTest.assertEquals((String)"24.12.2009 00:00", (String)ridget.getText());
    }

    private void assertText(String before, String keySeq, String after) {
        TestUtils.assertText((Text)this.getWidget(), (String)before, (String)keySeq, (String)after);
    }

    private void assertText(String before, int keyCode, String after) {
        TestUtils.assertText((Text)this.getWidget(), (String)before, (int)keyCode, (String)after);
    }
}

