/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.ui.swt.component.LogoComposite;
import org.eclipse.riena.ui.swt.lnf.ImageLnfResource;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class LogoCompositeTest
extends TestCase {
    private static final String ICON_ECLIPSE = "eclipse.gif";
    private LogoComposite logoComposite;
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.shell.setLayout((Layout)new FormLayout());
        this.logoComposite = new LogoComposite((Composite)this.shell, 0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SwtUtilities.disposeWidget((Widget)this.logoComposite);
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testGetLogoImage() {
        RienaDefaultLnf originaLnf = LnfManager.getLnf();
        try {
            MyLnf lnf = new MyLnf();
            LnfManager.setLnf((RienaDefaultLnf)lnf);
            lnf.initialize();
            Image eclipseImage = ImageStore.getInstance().getImage(ICON_ECLIPSE);
            lnf.setLogo(ICON_ECLIPSE);
            Image logoImage = (Image)ReflectionUtils.invokeHidden((Object)this.logoComposite, (String)"getLogoImage", (Object[])new Object[0]);
            LogoCompositeTest.assertNotNull((Object)logoImage);
            LogoCompositeTest.assertEquals((int)eclipseImage.getBounds().width, (int)logoImage.getBounds().width);
            LogoCompositeTest.assertEquals((int)eclipseImage.getBounds().height, (int)logoImage.getBounds().height);
            Image missingImage = ImageStore.getInstance().getMissingImage();
            lnf.setLogo("eclipse.gif4711");
            logoImage = (Image)ReflectionUtils.invokeHidden((Object)this.logoComposite, (String)"getLogoImage", (Object[])new Object[0]);
            LogoCompositeTest.assertNotNull((Object)logoImage);
            LogoCompositeTest.assertEquals((int)missingImage.getBounds().width, (int)logoImage.getBounds().width);
            LogoCompositeTest.assertEquals((int)missingImage.getBounds().height, (int)logoImage.getBounds().height);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originaLnf);
        }
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        public void setLogo(String logo) {
            this.getResourceTable().put("TitlelessShell.logo", new ImageLnfResource(logo));
        }
    }
}

