/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.ModuleGroupController;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.NavigationViewFactory;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.navigation.ui.swt.views.TestModuleController;
import org.eclipse.riena.navigation.ui.swt.views.TestModuleGroupController;
import org.eclipse.riena.navigation.ui.swt.views.TestModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.TestModuleView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class NavigationViewFactoryTest
extends RienaTestCase {
    public void testNormalWithoutInjectionBehaviour() {
        NavigationViewFactory viewFactory = new NavigationViewFactory();
        ModuleView moduleView = viewFactory.createModuleView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleView);
        NavigationViewFactoryTest.assertTrue((moduleView.getClass() == ModuleView.class ? 1 : 0) != 0);
        ModuleGroupView moduleGroupView = viewFactory.createModuleGroupView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleGroupView);
        NavigationViewFactoryTest.assertTrue((moduleGroupView.getClass() == ModuleGroupView.class ? 1 : 0) != 0);
    }

    public void testNormalWithInjectionBehaviour() {
        NavigationViewFactory viewFactory = new NavigationViewFactory();
        Wire.instance((Object)viewFactory).andStart(this.getContext());
        ModuleView moduleView = viewFactory.createModuleView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleView);
        NavigationViewFactoryTest.assertTrue((moduleView.getClass() == ModuleView.class ? 1 : 0) != 0);
        ModuleGroupView moduleGroupView = viewFactory.createModuleGroupView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleGroupView);
        NavigationViewFactoryTest.assertTrue((moduleGroupView.getClass() == ModuleGroupView.class ? 1 : 0) != 0);
    }

    public void testConfiguredNavigationViewFactory() {
        NavigationViewFactory viewFactory = new NavigationViewFactory();
        this.addPluginXml(((Object)((Object)this)).getClass(), "pluginXmlNavigationViewFactory.xml");
        Wire.instance((Object)viewFactory).andStart(this.getContext());
        ModuleView moduleView = viewFactory.createModuleView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleView);
        NavigationViewFactoryTest.assertTrue((moduleView.getClass() == TestModuleView.class ? 1 : 0) != 0);
        ModuleController moduleController = viewFactory.createModuleController((IModuleNode)new ModuleNode());
        NavigationViewFactoryTest.assertNotNull((Object)moduleController);
        NavigationViewFactoryTest.assertTrue((moduleController.getClass() == SWTModuleController.class ? 1 : 0) != 0);
        ModuleGroupView moduleGroupView = viewFactory.createModuleGroupView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleGroupView);
        NavigationViewFactoryTest.assertTrue((moduleGroupView.getClass() == TestModuleGroupView.class ? 1 : 0) != 0);
        ModuleGroupController moduleGroupController = viewFactory.createModuleGroupController((IModuleGroupNode)new ModuleGroupNode());
        NavigationViewFactoryTest.assertNotNull((Object)moduleGroupController);
        NavigationViewFactoryTest.assertTrue((moduleGroupController.getClass() == ModuleGroupController.class ? 1 : 0) != 0);
        this.removeExtension("org.eclipse.riena.test.navigationModuleView");
        this.removeExtension("org.eclipse.riena.test.navigationModuleGroupView");
    }

    public void testConfiguredNavigationViewFactorySecond() {
        NavigationViewFactory viewFactory = new NavigationViewFactory();
        this.addPluginXml(((Object)((Object)this)).getClass(), "pluginXmlNavigationViewFactoryWithController.xml");
        Wire.instance((Object)viewFactory).andStart(this.getContext());
        ModuleView moduleView = viewFactory.createModuleView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleView);
        NavigationViewFactoryTest.assertTrue((moduleView.getClass() == TestModuleView.class ? 1 : 0) != 0);
        ModuleController moduleController = viewFactory.createModuleController((IModuleNode)new ModuleNode());
        NavigationViewFactoryTest.assertNotNull((Object)moduleController);
        NavigationViewFactoryTest.assertTrue((moduleController.getClass() == TestModuleController.class ? 1 : 0) != 0);
        ModuleGroupView moduleGroupView = viewFactory.createModuleGroupView((Composite)new Shell());
        NavigationViewFactoryTest.assertNotNull((Object)moduleGroupView);
        NavigationViewFactoryTest.assertTrue((moduleGroupView.getClass() == TestModuleGroupView.class ? 1 : 0) != 0);
        ModuleGroupController moduleGroupController = viewFactory.createModuleGroupController((IModuleGroupNode)new ModuleGroupNode());
        NavigationViewFactoryTest.assertNotNull((Object)moduleGroupController);
        NavigationViewFactoryTest.assertTrue((moduleGroupController.getClass() == TestModuleGroupController.class ? 1 : 0) != 0);
        this.removeExtension("org.eclipse.riena.test.navigationModuleView");
        this.removeExtension("org.eclipse.riena.test.navigationModuleGroupView");
    }
}

