/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.renderer;

import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.ui.swt.lnf.FontLnfResource;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.DialogTitleBarRenderer;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class DialogTitleBarRendererTest
extends RienaTestCase {
    private static final String ICON_ECLIPSE = "eclipse.gif";
    private OpenDialogTitleBarRenderer renderer;
    private Shell shell;
    private GC gc;
    private RienaDefaultLnf originalLnf;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = new OpenDialogTitleBarRenderer();
        this.shell = new Shell();
        this.gc = new GC((Drawable)this.shell);
        this.renderer.setShell(this.shell);
        this.renderer.setBounds(0, 0, 100, 100);
        this.originalLnf = LnfManager.getLnf();
    }

    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.renderer.dispose();
        LnfManager.setLnf((RienaDefaultLnf)this.originalLnf);
        super.tearDown();
    }

    public void testPaintTitle() {
        DialogLnf lnf = new DialogLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        lnf.setHideOsBorder(true);
        this.shell.setText("Hello");
        Rectangle bounds = this.renderer.paintTitle(this.gc);
        DialogTitleBarRendererTest.assertFalse((boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
        this.shell.setText("");
        bounds = this.renderer.paintTitle(this.gc);
        DialogTitleBarRendererTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)bounds);
        this.shell.setText("Hello");
        lnf.setHideOsBorder(false);
        bounds = this.renderer.paintTitle(this.gc);
        DialogTitleBarRendererTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)bounds);
    }

    public void testPaintImage() {
        Rectangle bounds;
        DialogLnf lnf = new DialogLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        lnf.setHideOsBorder(true);
        Image image = ImageStore.getInstance().getImage(ICON_ECLIPSE);
        if (Activator.getDefault() != null) {
            DialogTitleBarRendererTest.assertNotNull((Object)image);
            this.shell.setImage(image);
            bounds = this.renderer.paintImage(this.gc);
            DialogTitleBarRendererTest.assertFalse((boolean)bounds.equals((Object)new Rectangle(0, 0, 0, 0)));
            DialogTitleBarRendererTest.assertEquals((int)image.getBounds().width, (int)bounds.width);
            DialogTitleBarRendererTest.assertEquals((int)image.getBounds().height, (int)bounds.height);
        }
        lnf.setHideOsBorder(false);
        bounds = this.renderer.paintImage(this.gc);
        DialogTitleBarRendererTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)bounds);
        lnf.setHideOsBorder(true);
        this.shell.setImage(null);
        bounds = this.renderer.paintImage(this.gc);
        DialogTitleBarRendererTest.assertEquals((Object)new Rectangle(0, 0, 0, 0), (Object)bounds);
    }

    private static class DialogLnf
    extends RienaDefaultLnf {
        private DialogLnf() {
        }

        protected void initFontDefaults() {
            super.initFontDefaults();
            this.getResourceTable().put("Dialog.font", new FontLnfResource("Arial", 12, 0));
        }

        public void setHideOsBorder(boolean hide) {
            this.getSettingTable().put("Dialog.hideOsBorder", hide);
        }
    }

    private static class OpenDialogTitleBarRenderer
    extends DialogTitleBarRenderer {
        private OpenDialogTitleBarRenderer() {
        }

        public Rectangle paintTitle(GC gc) {
            return super.paintTitle(gc);
        }

        public Rectangle paintImage(GC gc) {
            return super.paintImage(gc);
        }
    }
}

