/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.RemoteQueriedElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;

public class RollbackProfileElement
extends RemoteQueriedElement {
    private String profileId;
    private long timestamp;
    private IProfile snapshot;
    private boolean isCurrent = false;
    static /* synthetic */ Class class$0;

    public RollbackProfileElement(Object parent, String profileId, long timestamp) {
        super(parent);
        this.timestamp = timestamp;
        this.profileId = profileId;
    }

    protected String getImageId(Object obj) {
        return "obj/profile_obj.gif";
    }

    public String getLabel(Object o) {
        if (this.isCurrent) {
            return ProvUIMessages.RollbackProfileElement_CurrentInstallation;
        }
        return DateFormat.getDateTimeInstance((int)3, (int)1).format(new Date(this.timestamp));
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            try {
                return this.getProfileSnapshot((IProgressMonitor)new NullProgressMonitor());
            }
            catch (ProvisionException e) {
                this.handleException((Exception)((Object)e), ProvUIMessages.RollbackProfileElement_InvalidSnapshot);
            }
        }
        return super.getAdapter(adapter);
    }

    public IProfile getProfileSnapshot(IProgressMonitor monitor) throws ProvisionException {
        if (this.snapshot == null) {
            this.snapshot = ProvisioningUtil.getProfile(this.profileId, this.timestamp);
            this.setQueryable((IQueryable)this.snapshot);
        }
        return this.snapshot;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setIsCurrentProfile(boolean current) {
        this.isCurrent = current;
    }

    public boolean isCurrentProfile() {
        return this.isCurrent;
    }

    protected int getDefaultQueryType() {
        return 6;
    }

    public IQueryable getQueryable() {
        try {
            return this.getProfileSnapshot((IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            this.handleException((Exception)((Object)e), null);
            return null;
        }
    }
}

