/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.InstallBundleAction;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class UninstallBundleAction
extends ProvisioningAction {
    public static final String ID = "uninstallBundle";

    public IStatus execute(Map parameters) {
        return UninstallBundleAction.uninstallBundle(parameters);
    }

    public IStatus undo(Map parameters) {
        return InstallBundleAction.installBundle(parameters);
    }

    public static IStatus uninstallBundle(Map parameters) {
        IProfile profile = (IProfile)parameters.get("profile");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        String bundleId = (String)parameters.get("bundle");
        if (bundleId == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"bundle", (Object)ID));
        }
        if (iu.isFragment()) {
            System.out.println("What is a fragment doing here!!! -- " + iu);
            return Status.OK_STATUS;
        }
        IArtifactKey[] artifacts = iu.getArtifacts();
        if (artifacts == null || artifacts.length == 0) {
            return Util.createError(NLS.bind((String)Messages.iu_contains_no_arifacts, (Object)iu));
        }
        IArtifactKey artifactKey = null;
        int i = 0;
        while (i < artifacts.length) {
            if (artifacts[i].toString().equals(bundleId)) {
                artifactKey = artifacts[i];
                break;
            }
            ++i;
        }
        if (artifactKey == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.no_matching_artifact, (Object)bundleId));
        }
        File bundleFile = Util.getArtifactFile(artifactKey, profile);
        String manifest = Util.getManifest(iu.getTouchpointData());
        if (manifest == null) {
            return Util.createError(NLS.bind((String)Messages.missing_manifest, (Object)iu));
        }
        BundleInfo bundleInfo = Util.createBundleInfo(bundleFile, manifest);
        if (bundleInfo == null) {
            return Util.createError(NLS.bind((String)Messages.failed_bundleinfo, (Object)iu));
        }
        manipulator.getConfigData().removeBundle(bundleInfo);
        return Status.OK_STATUS;
    }
}

