/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMemberProvider;
import org.osgi.framework.Filter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableUnit
implements IInstallableUnit,
IMemberProvider {
    private static final OrderedProperties NO_PROPERTIES = new OrderedProperties();
    private static final IProvidedCapability[] NO_PROVIDES = new IProvidedCapability[0];
    private static final IRequirement[] NO_REQUIRES = new IRequirement[0];
    private static final IArtifactKey[] NO_ARTIFACTS = new IArtifactKey[0];
    private static final ITouchpointData[] NO_TOUCHPOINT_DATA = new ITouchpointData[0];
    private static final ILicense[] NO_LICENSE = new ILicense[0];
    private IArtifactKey[] artifacts = NO_ARTIFACTS;
    private Filter filter;
    private String id;
    private OrderedProperties properties;
    private OrderedProperties localizedProperties;
    IProvidedCapability[] providedCapabilities = NO_PROVIDES;
    private IRequirement[] requires = NO_REQUIRES;
    private IRequirement[] metaRequires = NO_REQUIRES;
    private boolean singleton;
    private ITouchpointData[] touchpointData = NO_TOUCHPOINT_DATA;
    private ITouchpointType touchpointType;
    private Version version = Version.emptyVersion;
    private IUpdateDescriptor updateInfo;
    private ILicense[] licenses = NO_LICENSE;
    private ICopyright copyright;

    public void addTouchpointData(ITouchpointData newData) {
        int tl = this.touchpointData.length;
        if (tl == 0) {
            this.touchpointData = new ITouchpointData[]{newData};
        } else {
            ITouchpointData[] newDatas = new ITouchpointData[tl + 1];
            System.arraycopy(this.touchpointData, 0, newDatas, 0, tl);
            newDatas[tl] = newData;
            this.touchpointData = newDatas;
        }
    }

    @Override
    public int compareTo(IInstallableUnit other) {
        int cmp = this.getId().compareTo(other.getId());
        if (cmp == 0) {
            cmp = this.getVersion().compareTo(other.getVersion());
        }
        return cmp;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IInstallableUnit)) {
            return false;
        }
        IInstallableUnit other = (IInstallableUnit)obj;
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        return !(this.getVersion() == null ? other.getVersion() != null : !this.getVersion().equals(other.getVersion()));
    }

    @Override
    public Collection<IArtifactKey> getArtifacts() {
        return CollectionUtils.unmodifiableList((Object[])this.artifacts);
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public List<IInstallableUnitFragment> getFragments() {
        return CollectionUtils.emptyList();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, String> getProperties() {
        return OrderedProperties.unmodifiableProperties((Map)this.properties());
    }

    public String getLocalizedProperty(String key) {
        String result = null;
        if (this.localizedProperties != null) {
            result = this.localizedProperties.getProperty(key);
        }
        return result;
    }

    @Override
    public String getProperty(String key) {
        return this.properties().getProperty(key);
    }

    @Override
    public Collection<IProvidedCapability> getProvidedCapabilities() {
        return CollectionUtils.unmodifiableList((Object[])this.providedCapabilities);
    }

    @Override
    public String getProperty(String key, String locale) {
        return TranslationSupport.getInstance().getIUProperty(this, key, locale);
    }

    public List<IRequirement> getRequiredCapabilities() {
        return CollectionUtils.unmodifiableList((Object[])this.requires);
    }

    @Override
    public List<ITouchpointData> getTouchpointData() {
        return CollectionUtils.unmodifiableList((Object[])this.touchpointData);
    }

    @Override
    public ITouchpointType getTouchpointType() {
        return this.touchpointType != null ? this.touchpointType : ITouchpointType.NONE;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return result;
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    private OrderedProperties properties() {
        return this.properties != null ? this.properties : NO_PROPERTIES;
    }

    public void setArtifacts(IArtifactKey[] value) {
        this.artifacts = value == null || value.length == 0 ? NO_ARTIFACTS : value;
    }

    public void setCapabilities(IProvidedCapability[] newCapabilities) {
        this.providedCapabilities = newCapabilities == null || newCapabilities.length == 0 ? NO_PROVIDES : newCapabilities;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setFilter(String filter) {
        this.setFilter(filter == null ? null : ExpressionUtil.parseLDAP(filter));
    }

    public void setId(String id) {
        this.id = id;
    }

    public String setLocalizedProperty(String key, String value) {
        if (this.localizedProperties == null) {
            this.localizedProperties = new OrderedProperties();
        }
        return this.localizedProperties.put(key, value);
    }

    public String setProperty(String key, String value) {
        if (value == null) {
            return this.properties != null ? this.properties.remove((Object)key) : null;
        }
        if (this.properties == null) {
            this.properties = new OrderedProperties();
        }
        return (String)this.properties.setProperty(key, value);
    }

    public void setRequiredCapabilities(IRequirement[] capabilities) {
        this.requires = capabilities.length == 0 ? NO_REQUIRES : (IRequirement[])capabilities.clone();
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setTouchpointType(ITouchpointType type) {
        this.touchpointType = type != ITouchpointType.NONE ? type : null;
    }

    public void setVersion(Version newVersion) {
        this.version = newVersion != null ? newVersion : Version.emptyVersion;
    }

    public String toString() {
        return new StringBuffer(String.valueOf(this.id)).append(' ').append(this.getVersion()).toString();
    }

    @Override
    public IInstallableUnit unresolved() {
        return this;
    }

    @Override
    public IUpdateDescriptor getUpdateDescriptor() {
        return this.updateInfo;
    }

    public void setUpdateDescriptor(IUpdateDescriptor updateInfo) {
        this.updateInfo = updateInfo;
    }

    public void setLicenses(ILicense[] license) {
        this.licenses = license == null ? NO_LICENSE : license;
    }

    @Override
    public Collection<ILicense> getLicenses() {
        return CollectionUtils.unmodifiableList((Object[])this.licenses);
    }

    @Override
    public ILicense[] getLicenses(String locale) {
        return TranslationSupport.getInstance().getLicenses(this, locale);
    }

    public void setCopyright(ICopyright copyright) {
        this.copyright = copyright;
    }

    @Override
    public ICopyright getCopyright() {
        return this.copyright;
    }

    @Override
    public ICopyright getCopyright(String locale) {
        return TranslationSupport.getInstance().getCopyright(this, locale);
    }

    @Override
    public boolean satisfies(IRequirement candidate) {
        return candidate.isMatch(this);
    }

    @Override
    public Collection<IRequirement> getMetaRequiredCapabilities() {
        return CollectionUtils.unmodifiableList((Object[])this.metaRequires);
    }

    public void setMetaRequiredCapabilities(IRequirement[] metaReqs) {
        this.metaRequires = metaReqs.length == 0 ? NO_REQUIRES : (IRequirement[])metaReqs.clone();
    }

    @Override
    public Object getMember(String memberName) {
        if ("providedCapabilities".equals(memberName)) {
            return this.providedCapabilities;
        }
        if ("id".equals(memberName)) {
            return this.id;
        }
        if ("version".equals(memberName)) {
            return this.version;
        }
        if ("properties".equals(memberName)) {
            return this.properties;
        }
        if ("filter".equals(memberName)) {
            return this.filter;
        }
        if ("artifacts".equals(memberName)) {
            return this.artifacts;
        }
        if ("requiredCapabilities".equals(memberName)) {
            return this.requires;
        }
        if ("licenses".equals(memberName)) {
            return this.licenses;
        }
        if ("copyright".equals(memberName)) {
            return this.copyright;
        }
        if ("touchpointData".equals(memberName)) {
            return this.touchpointData;
        }
        if ("touchpointType".equals(memberName)) {
            return this.touchpointType;
        }
        if ("updateDescriptor".equals(memberName)) {
            return this.updateInfo;
        }
        if ("singleton".equals(memberName)) {
            return this.singleton;
        }
        throw new IllegalArgumentException();
    }
}

