/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IMemberProvider;

public class ProvidedCapability
implements IProvidedCapability,
IMemberProvider {
    private final String name;
    private final String namespace;
    private final Version version;

    public ProvidedCapability(String namespace, String name, Version version) {
        Assert.isNotNull((Object)namespace);
        Assert.isNotNull((Object)name);
        this.namespace = namespace;
        this.name = name;
        this.version = version == null ? Version.emptyVersion : version;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof IProvidedCapability)) {
            return false;
        }
        IProvidedCapability otherCapability = (IProvidedCapability)other;
        if (!this.namespace.equals(otherCapability.getNamespace())) {
            return false;
        }
        if (!this.name.equals(otherCapability.getName())) {
            return false;
        }
        return this.version.equals(otherCapability.getVersion());
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.namespace.hashCode() * this.name.hashCode() * this.version.hashCode();
    }

    public String toString() {
        return String.valueOf(this.namespace) + '/' + this.name + '/' + this.version;
    }

    public Object getMember(String memberName) {
        if ("name".equals(memberName)) {
            return this.name;
        }
        if ("namespace".equals(memberName)) {
            return this.namespace;
        }
        if ("version".equals(memberName)) {
            return this.version;
        }
        throw new IllegalArgumentException();
    }
}

