/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.Variable;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.SimplePattern;
import org.osgi.framework.Filter;

public final class Literal
extends Expression {
    public static final Literal FALSE_CONSTANT = new Literal(Boolean.FALSE);
    public static final Literal NULL_CONSTANT = new Literal(null);
    public static final Literal TRUE_CONSTANT = new Literal(Boolean.TRUE);
    public final Object value;

    static Literal create(Object value) {
        if (value == null) {
            return NULL_CONSTANT;
        }
        if (value == Boolean.TRUE) {
            return TRUE_CONSTANT;
        }
        if (value == Boolean.FALSE) {
            return FALSE_CONSTANT;
        }
        return new Literal(value);
    }

    private Literal(Object value) {
        this.value = value;
    }

    public int compareTo(Expression e) {
        int cmp = super.compareTo(e);
        if (cmp != 0) {
            return cmp;
        }
        Object eValue = ((Literal)e).value;
        if (this.value == null) {
            return eValue == null ? 0 : -1;
        }
        if (eValue == null) {
            return 1;
        }
        if (eValue.getClass() == this.value.getClass()) {
            return ((Comparable)this.value).compareTo(eValue);
        }
        return eValue.getClass().getName().compareTo(this.value.getClass().getName());
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            Literal bo = (Literal)o;
            return this.value == null ? bo.value == null : this.value.equals(bo.value);
        }
        return false;
    }

    public Object evaluate(IEvaluationContext context) {
        return this.value;
    }

    public int getExpressionType() {
        return 11;
    }

    public String getOperator() {
        return "<literal>";
    }

    public int getPriority() {
        return 1;
    }

    public int hashCode() {
        return 31 + this.value.hashCode();
    }

    public void toLDAPString(StringBuffer buf) {
        if (!(this.value instanceof Filter)) {
            throw new UnsupportedOperationException();
        }
        buf.append(this.value.toString());
    }

    public void toString(StringBuffer bld, Variable rootVariable) {
        if (this.value == null) {
            bld.append("null");
        } else if (this.value instanceof String || this.value instanceof Version) {
            String str = this.value.toString();
            char sep = str.indexOf(39) >= 0 ? (char)'\"' : '\'';
            bld.append(sep);
            bld.append(str);
            bld.append(sep);
        } else if (this.value instanceof SimplePattern) {
            this.appendEscaped(bld, '/', this.value.toString());
        } else {
            bld.append(this.value);
        }
    }

    private void appendEscaped(StringBuffer bld, char delimiter, String str) {
        bld.append(delimiter);
        int top = str.length();
        int idx = 0;
        while (idx < top) {
            char c = str.charAt(idx);
            if (c == delimiter) {
                bld.append('\\');
            }
            bld.append(c);
            ++idx;
        }
        bld.append(delimiter);
    }
}

