/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import org.eclipse.equinox.internal.p2.metadata.expression.Binary;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.LDAPApproximation;
import org.eclipse.equinox.internal.p2.metadata.expression.Literal;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.SimplePattern;

public class Matches
extends Binary {
    protected Matches(Expression lhs, Expression rhs) {
        super(lhs, rhs);
    }

    public Object evaluate(IEvaluationContext context) {
        return this.match(this.lhs.evaluate(context), this.rhs.evaluate(context));
    }

    protected boolean match(Object lval, Object rval) {
        if (rval instanceof VersionRange) {
            VersionRange range = (VersionRange)rval;
            if (lval instanceof Version) {
                return range.isIncluded((Version)lval);
            }
            if (lval instanceof String) {
                return range.isIncluded(Version.create((String)lval));
            }
        }
        if (rval instanceof SimplePattern) {
            if (lval instanceof CharSequence) {
                return ((SimplePattern)rval).isMatch((CharSequence)lval);
            }
            if (lval instanceof Character || lval instanceof Number || lval instanceof Boolean) {
                return ((SimplePattern)rval).isMatch(lval.toString());
            }
        } else if (rval instanceof LDAPApproximation) {
            if (lval instanceof CharSequence) {
                return ((LDAPApproximation)rval).isMatch((CharSequence)lval);
            }
            if (lval instanceof Character || lval instanceof Number || lval instanceof Boolean) {
                return ((LDAPApproximation)rval).isMatch(lval.toString());
            }
        } else if (rval instanceof Class) {
            Class rclass = (Class)rval;
            return lval instanceof Class ? rclass.isAssignableFrom((Class)lval) : rclass.isInstance(lval);
        }
        if (lval == null || rval == null) {
            return false;
        }
        throw new IllegalArgumentException("Cannot match a " + lval.getClass().getName() + " with a " + rval.getClass().getName());
    }

    public int getExpressionType() {
        return 12;
    }

    public String getOperator() {
        return "~=";
    }

    public void toLDAPString(StringBuffer buf) {
        if (!(this.rhs instanceof Literal)) {
            throw new UnsupportedOperationException();
        }
        boolean escapeWild = true;
        Object val = this.rhs.evaluate(null);
        buf.append('(');
        this.appendLDAPAttribute(buf);
        if (val instanceof LDAPApproximation) {
            buf.append(this.getOperator());
        } else if (val instanceof SimplePattern) {
            buf.append('=');
            escapeWild = false;
        } else {
            throw new UnsupportedOperationException();
        }
        Matches.appendLDAPEscaped(buf, val.toString(), escapeWild);
        buf.append(')');
    }
}

