/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.ContextQuery;
import org.eclipse.equinox.p2.query.IQueryResult;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatestIUVersionQuery<T extends IVersionedId>
extends ContextQuery<T> {
    @Override
    public IQueryResult<T> perform(Iterator<T> iterator) {
        HashMap<String, IVersionedId> greatestIUVersion = new HashMap<String, IVersionedId>();
        while (iterator.hasNext()) {
            IVersionedId versionedID = (IVersionedId)iterator.next();
            if (greatestIUVersion.containsKey(versionedID.getId())) {
                IVersionedId currentIU = (IVersionedId)greatestIUVersion.get(versionedID.getId());
                if (currentIU.getVersion().compareTo(versionedID.getVersion()) >= 0) continue;
                greatestIUVersion.put(versionedID.getId(), versionedID);
                continue;
            }
            greatestIUVersion.put(versionedID.getId(), versionedID);
        }
        Collection values = greatestIUVersion.values();
        Iterator valuesIterator = values.iterator();
        boolean continueGather = true;
        Collector<IVersionedId> result = new Collector<IVersionedId>();
        while (valuesIterator.hasNext() && continueGather) {
            IVersionedId nextIU = (IVersionedId)valuesIterator.next();
            continueGather = result.accept(nextIU);
        }
        return result;
    }
}

