/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundQueryable<T>
implements IQueryable<T> {
    private IQueryable<T>[] queryables;

    private CompoundQueryable(IQueryable<T>[] queryables) {
        this.queryables = queryables;
    }

    public CompoundQueryable(Collection<? extends IQueryable<T>> queryables) {
        this(queryables.toArray(new IQueryable[queryables.size()]));
    }

    public CompoundQueryable(IQueryable<T> query1, IQueryable<T> query2) {
        this(new IQueryable[]{query1, query2});
    }

    public CompoundQueryable(IQueryable<T> query1, IQueryable<T> query2, IQueryable<T> query3) {
        this(new IQueryable[]{query1, query2, query3});
    }

    @Override
    public IQueryResult<T> query(IQuery<T> query, IProgressMonitor monitor) {
        boolean isMatchQuery;
        IQueryResult<T> subResults = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int totalWork = (isMatchQuery = query instanceof IMatchQuery) ? this.queryables.length : this.queryables.length + 1;
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(totalWork * 10));
            Collector results = !isMatchQuery ? new ListCollector() : new Collector();
            int i = 0;
            while (i < this.queryables.length) {
                if (subMonitor.isCanceled()) break;
                subResults = this.queryables[i].query(query, (IProgressMonitor)subMonitor.newChild(10));
                results.addAll(subResults);
                ++i;
            }
            if (isMatchQuery) {
                Collector collector = results;
                return collector;
            }
            IQueryResult<T> iQueryResult = results.query(query, (IProgressMonitor)subMonitor.newChild(10));
            return iQueryResult;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListCollector<T>
    extends Collector<T> {
        private List<T> collected;

        @Override
        protected Collection<T> getCollection() {
            if (this.collected == null) {
                this.collected = new ArrayList<T>();
            }
            return this.collected;
        }

        @Override
        public boolean isEmpty() {
            return this.collected == null || this.collected.isEmpty();
        }

        @Override
        public T[] toArray(Class<? extends T> clazz) {
            int size = this.collected == null ? 0 : this.collected.size();
            Object[] result = (Object[])Array.newInstance(clazz, size);
            if (size != 0) {
                this.collected.toArray(result);
            }
            return result;
        }

        @Override
        public boolean accept(T object) {
            if (this.collected == null) {
                this.collected = new ArrayList<T>();
            }
            this.collected.add(object);
            return true;
        }

        @Override
        public Set<T> toSet() {
            return this.collected == null ? new HashSet() : new HashSet<T>(this.collected);
        }

        @Override
        public Iterator<T> iterator() {
            return this.collected == null ? CollectionUtils.emptyList().iterator() : this.collected.iterator();
        }

        @Override
        public int size() {
            return this.collected == null ? 0 : this.collected.size();
        }
    }
}

