/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    public static final String ID = "org.eclipse.equinox.p2.artifact.repository";
    public static final String REPO_PROVIDER_XPT = "org.eclipse.equinox.p2.artifact.repository.artifactRepositories";
    private static BundleContext context;
    private ServiceRegistration repositoryManagerRegistration;
    private static final Map<ArtifactRepositoryManager, IProvisioningAgent> createdManagers;
    private ServiceTracker agentTracker;

    static {
        createdManagers = new HashMap<ArtifactRepositoryManager, IProvisioningAgent>();
    }

    public static BundleContext getContext() {
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addManager(ArtifactRepositoryManager manager, IProvisioningAgent agent) {
        Map<ArtifactRepositoryManager, IProvisioningAgent> map = createdManagers;
        synchronized (map) {
            createdManagers.put(manager, agent);
        }
    }

    public void start(BundleContext aContext) throws Exception {
        context = aContext;
        String filter = "(&(objectClass=" + IProvisioningAgent.SERVICE_NAME + ")(agent.current=true))";
        this.agentTracker = new ServiceTracker(context, aContext.createFilter(filter), (ServiceTrackerCustomizer)this);
        this.agentTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext aContext) throws Exception {
        context = null;
        if (this.repositoryManagerRegistration != null) {
            this.repositoryManagerRegistration.unregister();
        }
        this.repositoryManagerRegistration = null;
        Map<ArtifactRepositoryManager, IProvisioningAgent> map = createdManagers;
        synchronized (map) {
            Iterator<ArtifactRepositoryManager> iterator = createdManagers.keySet().iterator();
            while (iterator.hasNext()) {
                ArtifactRepositoryManager manager = iterator.next();
                manager.shutdown();
                IProvisioningAgent agent = createdManagers.get((Object)manager);
                agent.unregisterService(IArtifactRepositoryManager.SERVICE_NAME, (Object)manager);
            }
            createdManagers.clear();
        }
        this.agentTracker.close();
    }

    public Object addingService(ServiceReference reference) {
        IProvisioningAgent agent = (IProvisioningAgent)context.getService(reference);
        this.repositoryManagerRegistration = context.registerService(IArtifactRepositoryManager.SERVICE_NAME, agent.getService(IArtifactRepositoryManager.SERVICE_NAME), null);
        return agent;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (this.repositoryManagerRegistration != null) {
            this.repositoryManagerRegistration.unregister();
            this.repositoryManagerRegistration = null;
        }
    }
}

