/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.RepositoryTransport;
import org.eclipse.equinox.p2.repository.IRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorSelector {
    private static final double LOG2 = Math.log(2.0);
    URI baseURI;
    MirrorInfo[] mirrors;
    private final IRepository<?> repository;
    private final Random random = new Random();

    public MirrorSelector(IRepository<?> repository) {
        this.repository = repository;
        try {
            String base = (String)repository.getProperties().get("p2.mirrorsBaseURL");
            if (base != null) {
                this.baseURI = new URI(base);
            } else {
                URI repositoryLocation = repository.getLocation();
                if (repositoryLocation != null) {
                    this.baseURI = repositoryLocation;
                }
            }
        }
        catch (URISyntaxException e) {
            this.log(new StringBuffer("Error initializing mirrors for: ").append(repository.getLocation()).toString(), e);
        }
    }

    private MirrorInfo[] computeMirrors(String mirrorsURL, IProgressMonitor monitor) {
        Document document;
        block7: {
            String timeZone;
            String countryCode = Activator.getContext().getProperty("eclipse.p2.countryCode");
            if (countryCode == null || countryCode.trim().length() == 0) {
                countryCode = Locale.getDefault().getCountry().toLowerCase();
            }
            if ((timeZone = Activator.getContext().getProperty("eclipse.p2.timeZone")) == null || timeZone.trim().length() == 0) {
                timeZone = Integer.toString(new GregorianCalendar().get(15) / 3600000);
            }
            mirrorsURL = mirrorsURL.indexOf(63) != -1 ? new StringBuffer(String.valueOf(mirrorsURL)).append('&').toString() : new StringBuffer(String.valueOf(mirrorsURL)).append('?').toString();
            mirrorsURL = new StringBuffer(String.valueOf(mirrorsURL)).append("countryCode=").append(countryCode).append("&timeZone=").append(timeZone).append("&format=xml").toString();
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            document = null;
            RepositoryTransport transport = RepositoryTransport.getInstance();
            InputSource input = new InputSource(mirrorsURL);
            input.setByteStream(transport.stream(URIUtil.fromString((String)mirrorsURL), monitor));
            document = builder.parse(input);
            if (document != null) break block7;
            return null;
        }
        try {
            NodeList mirrorNodes = document.getElementsByTagName("mirror");
            int mirrorCount = mirrorNodes.getLength();
            MirrorInfo[] infos = new MirrorInfo[mirrorCount + 1];
            int i = 0;
            while (i < mirrorCount) {
                Element mirrorNode = (Element)mirrorNodes.item(i);
                String infoURL = mirrorNode.getAttribute("url");
                infos[i] = new MirrorInfo(infoURL, i);
                ++i;
            }
            infos[mirrorCount] = new MirrorInfo(this.baseURI.toString(), mirrorCount);
            return infos;
        }
        catch (Exception e) {
            if (mirrorsURL != null && (mirrorsURL.startsWith("http://") || mirrorsURL.startsWith("https://") || mirrorsURL.startsWith("file://") || mirrorsURL.startsWith("ftp://") || mirrorsURL.startsWith("jar://"))) {
                this.log(new StringBuffer("Error processing mirrors URL: ").append(mirrorsURL).toString(), e);
            }
            return null;
        }
    }

    public synchronized URI getMirrorLocation(URI inputLocation, IProgressMonitor monitor) {
        Assert.isNotNull((Object)inputLocation);
        if (this.baseURI == null) {
            return inputLocation;
        }
        URI relativeLocation = this.baseURI.relativize(inputLocation);
        if (relativeLocation == null || relativeLocation.isAbsolute()) {
            return inputLocation;
        }
        MirrorInfo selectedMirror = this.selectMirror(monitor);
        if (selectedMirror == null) {
            return inputLocation;
        }
        if (Tracing.DEBUG_MIRRORS) {
            Tracing.debug((String)new StringBuffer("Selected mirror for artifact ").append(inputLocation).append(": ").append(selectedMirror).toString());
        }
        try {
            return new URI(new StringBuffer(String.valueOf(selectedMirror.locationString)).append(relativeLocation.getPath()).toString());
        }
        catch (URISyntaxException e) {
            this.log(new StringBuffer("Unable to make location ").append(inputLocation).append(" relative to mirror ").append(selectedMirror.locationString).toString(), e);
            return inputLocation;
        }
    }

    private MirrorInfo[] initMirrors(IProgressMonitor monitor) {
        if (this.mirrors != null) {
            return this.mirrors;
        }
        String mirrorsURL = (String)this.repository.getProperties().get("p2.mirrorsURL");
        if (mirrorsURL != null) {
            this.mirrors = this.computeMirrors(mirrorsURL, monitor);
        }
        return this.mirrors;
    }

    private void log(String message, Throwable exception) {
        LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", message, exception));
    }

    public synchronized void reportResult(String toDownload, IStatus result) {
        if (this.mirrors == null) {
            return;
        }
        int i = 0;
        while (i < this.mirrors.length) {
            MirrorInfo mirror = this.mirrors[i];
            if (toDownload.startsWith(mirror.locationString)) {
                if (!result.isOK() && result.getSeverity() != 8) {
                    mirror.incrementFailureCount();
                }
                if (result instanceof DownloadStatus) {
                    long oldRate = mirror.bytesPerSecond;
                    long newRate = ((DownloadStatus)result).getTransferRate();
                    if (oldRate > 0L) {
                        newRate = (oldRate + newRate) / 2L;
                    }
                    mirror.setBytesPerSecond(newRate);
                }
                if (Tracing.DEBUG_MIRRORS) {
                    Tracing.debug((String)new StringBuffer("Updated mirror ").append(mirror).toString());
                }
                Arrays.sort(this.mirrors);
                return;
            }
            ++i;
        }
    }

    public synchronized boolean hasValidMirror() {
        return this.mirrors != null && this.mirrors.length > 0 && this.mirrors[0].failureCount == 0;
    }

    private MirrorInfo selectMirror(IProgressMonitor monitor) {
        int mirrorCount;
        this.initMirrors(monitor);
        if (this.mirrors == null || (mirrorCount = this.mirrors.length) == 0) {
            return null;
        }
        int highestMirror = Math.min(15, mirrorCount);
        int result = (int)(Math.log(this.random.nextInt(1 << highestMirror) + 1) / LOG2);
        if (result >= highestMirror || result < 0) {
            result = highestMirror - 1;
        }
        MirrorInfo selected = this.mirrors[highestMirror - 1 - result];
        if (selected.failureCount > 0) {
            selected = this.mirrors[0];
        }
        if (selected.failureCount > 0) {
            return null;
        }
        return selected;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MirrorInfo
    implements Comparable<MirrorInfo> {
        long bytesPerSecond;
        int failureCount;
        private final int initialRank;
        String locationString;

        public MirrorInfo(String location, int initialRank) {
            this.initialRank = initialRank;
            this.locationString = location;
            if (!this.locationString.endsWith("/")) {
                this.locationString = new StringBuffer(String.valueOf(this.locationString)).append("/").toString();
            }
            this.failureCount = 0;
            this.bytesPerSecond = -1L;
        }

        @Override
        public int compareTo(MirrorInfo that) {
            if (this.failureCount != that.failureCount) {
                return this.failureCount - that.failureCount;
            }
            if (this.bytesPerSecond != that.bytesPerSecond) {
                return (int)(that.bytesPerSecond - this.bytesPerSecond);
            }
            return this.initialRank - that.initialRank;
        }

        public void incrementFailureCount() {
            ++this.failureCount;
        }

        public void setBytesPerSecond(long newValue) {
            this.bytesPerSecond = newValue;
        }

        public String toString() {
            return new StringBuffer("Mirror(").append(this.locationString).append(',').append(this.failureCount).append(',').append(this.bytesPerSecond).append(')').toString();
        }
    }
}

