/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositoryNameAndLocationDialog;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ColocatedRepositoryTracker
extends RepositoryTracker {
    ProvisioningUI ui;

    public ColocatedRepositoryTracker() {
        this(ProvisioningUI.getDefaultUI());
    }

    public ColocatedRepositoryTracker(ProvisioningUI ui) {
        this.ui = ui;
        this.setArtifactRepositoryFlags(2);
        this.setMetadataRepositoryFlags(2);
    }

    public URI[] getKnownRepositories(ProvisioningSession session) {
        return session.getMetadataRepositoryManager().getKnownRepositories(this.getMetadataRepositoryFlags());
    }

    protected IStatus validateRepositoryLocationWithManager(ProvisioningSession session, URI location, IProgressMonitor monitor) {
        return session.getMetadataRepositoryManager().validateRepositoryLocation(location, monitor);
    }

    public void addRepository(URI repoLocation, String nickname, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            session.getMetadataRepositoryManager().addRepository(repoLocation);
            session.getArtifactRepositoryManager().addRepository(repoLocation);
            if (nickname != null) {
                session.getMetadataRepositoryManager().setRepositoryProperty(repoLocation, "p2.nickname", nickname);
                session.getArtifactRepositoryManager().setRepositoryProperty(repoLocation, "p2.nickname", nickname);
            }
        }
        finally {
            this.ui.signalRepositoryOperationComplete(new RepositoryEvent(repoLocation, 0, 0, true), true);
        }
    }

    public void removeRepositories(URI[] repoLocations, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            int i = 0;
            while (i < repoLocations.length) {
                session.getMetadataRepositoryManager().removeRepository(repoLocations[i]);
                session.getArtifactRepositoryManager().removeRepository(repoLocations[i]);
                ++i;
            }
        }
        finally {
            this.ui.signalRepositoryOperationComplete(null, true);
        }
    }

    public void refreshRepositories(URI[] locations, ProvisioningSession session, IProgressMonitor monitor) {
        this.ui.signalRepositoryOperationStart();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(locations.length * 100));
        int i = 0;
        while (i < locations.length) {
            try {
                session.getArtifactRepositoryManager().refreshRepository(locations[i], (IProgressMonitor)mon.newChild(50));
                session.getMetadataRepositoryManager().refreshRepository(locations[i], (IProgressMonitor)mon.newChild(50));
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        this.ui.signalRepositoryOperationComplete(null, true);
    }

    public void reportLoadFailure(final URI location, ProvisionException e) {
        int code = e.getStatus().getCode();
        if (!this.ui.getPolicy().getRepositoriesVisible()) {
            super.reportLoadFailure(location, e);
            return;
        }
        if (code == 1000 || code == 1006) {
            if (!this.hasNotFoundStatusBeenReported(location)) {
                this.addNotFound(location);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        URI correctedLocation;
                        RepositoryNameAndLocationDialog dialog;
                        int ret;
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        if (workbench.isClosing()) {
                            return;
                        }
                        Shell shell = ProvUI.getDefaultParentShell();
                        if (MessageDialog.openQuestion((Shell)shell, (String)ProvUIMessages.ColocatedRepositoryTracker_SiteNotFoundTitle, (String)NLS.bind((String)ProvUIMessages.ColocatedRepositoryTracker_PromptForSiteLocationEdit, (Object)URIUtil.toUnencodedString((URI)location))) && (ret = (dialog = new RepositoryNameAndLocationDialog(shell, ColocatedRepositoryTracker.this.ui){

                            protected String getInitialLocationText() {
                                return URIUtil.toUnencodedString((URI)location);
                            }

                            protected String getInitialNameText() {
                                String nickname = (this).ColocatedRepositoryTracker.this.ui.getSession().getMetadataRepositoryManager().getRepositoryProperty(location, "p2.nickname");
                                return nickname == null ? "" : nickname;
                            }
                        }).open()) == 0 && (correctedLocation = dialog.getLocation()) != null) {
                            ColocatedRepositoryTracker.this.ui.signalRepositoryOperationStart();
                            try {
                                ColocatedRepositoryTracker.this.removeRepositories(new URI[]{location}, ColocatedRepositoryTracker.this.ui.getSession());
                                ColocatedRepositoryTracker.this.addRepository(correctedLocation, dialog.getName(), ColocatedRepositoryTracker.this.ui.getSession());
                            }
                            finally {
                                ColocatedRepositoryTracker.this.ui.signalRepositoryOperationComplete(null, true);
                            }
                        }
                    }
                });
            }
        } else {
            ProvUI.handleException(e, null, 3);
        }
    }
}

